<?php

namespace ebay\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TopRatedSellerDetailsType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Container for top-rated seller program information.
 * @subpackage Structs
 * @date 2017-04-07 16
 */
class TopRatedSellerDetailsType extends AbstractStructBase
{
    /**
     * The TopRatedProgram
     * Meta informations extracted from the WSDL
     * - documentation: Top-rated seller program details for the seller. Returned when the seller is qualified as a top-rated seller.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $TopRatedProgram;
    /**
     * The any
     * @var \DOMDocument
     */
    public $any;
    /**
     * Constructor method for TopRatedSellerDetailsType
     * @uses TopRatedSellerDetailsType::setTopRatedProgram()
     * @uses TopRatedSellerDetailsType::setAny()
     * @param string[] $topRatedProgram
     * @param \DOMDocument $any
     */
    public function __construct(array $topRatedProgram = array(), \DOMDocument $any = null)
    {
        $this
            ->setTopRatedProgram($topRatedProgram)
            ->setAny($any);
    }
    /**
     * Get TopRatedProgram value
     * @return string[]|null
     */
    public function getTopRatedProgram()
    {
        return $this->TopRatedProgram;
    }
    /**
     * Set TopRatedProgram value
     * @uses \ebay\EnumType\TopRatedProgramCodeType::valueIsValid()
     * @uses \ebay\EnumType\TopRatedProgramCodeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $topRatedProgram
     * @return \ebay\StructType\TopRatedSellerDetailsType
     */
    public function setTopRatedProgram(array $topRatedProgram = array())
    {
        $invalidValues = array();
        foreach ($topRatedProgram as $topRatedSellerDetailsTypeTopRatedProgramItem) {
            if (!\ebay\EnumType\TopRatedProgramCodeType::valueIsValid($topRatedSellerDetailsTypeTopRatedProgramItem)) {
                $invalidValues[] = var_export($topRatedSellerDetailsTypeTopRatedProgramItem);
            }
        }
        if (!empty($invalidValues)) {
            throw new \InvalidArgumentException(sprintf('Value(s) "%s" is/are invalid, please use one of: %s', implode(', ', $invalidValues), implode(', ', \ebay\EnumType\TopRatedProgramCodeType::getValidValues())), __LINE__);
        }
        $this->TopRatedProgram = $topRatedProgram;
        return $this;
    }
    /**
     * Add item to TopRatedProgram value
     * @uses \ebay\EnumType\TopRatedProgramCodeType::valueIsValid()
     * @uses \ebay\EnumType\TopRatedProgramCodeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \ebay\StructType\TopRatedSellerDetailsType
     */
    public function addToTopRatedProgram($item)
    {
        // validation for constraint: enumeration
        if (!\ebay\EnumType\TopRatedProgramCodeType::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $item, implode(', ', \ebay\EnumType\TopRatedProgramCodeType::getValidValues())), __LINE__);
        }
        $this->TopRatedProgram[] = $item;
        return $this;
    }
    /**
     * Get any value
     * @uses \DOMDocument::loadXML()
     * @uses \DOMDocument::hasChildNodes()
     * @uses \DOMDocument::saveXML()
     * @uses \DOMNode::item()
     * @uses \ebay\StructType\TopRatedSellerDetailsType::setAny()
     * @param bool $asString true: returns XML string, false: returns \DOMDocument
     * @return \DOMDocument|null
     */
    public function getAny($asString = true)
    {
        if (!empty($this->any) && !($this->any instanceof \DOMDocument)) {
            $dom = new \DOMDocument('1.0', 'UTF-8');
            $dom->formatOutput = true;
            if ($dom->loadXML($this->any)) {
                $this->setAny($dom);
            }
            unset($dom);
        }
        return ($asString && ($this->any instanceof \DOMDocument) && $this->any->hasChildNodes()) ? $this->any->saveXML($this->any->childNodes->item(0)) : $this->any;
    }
    /**
     * Set any value
     * @param \DOMDocument $any
     * @return \ebay\StructType\TopRatedSellerDetailsType
     */
    public function setAny(\DOMDocument $any = null)
    {
        $this->any = $any;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \ebay\StructType\TopRatedSellerDetailsType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
