<?php

namespace ebay\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SetStoreRequestType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Sets the configuration of the eBay store owned by the caller.
 * @subpackage Structs
 * @date 2017-04-07 16
 */
class SetStoreRequestType extends AbstractRequestType
{
    /**
     * The Store
     * Meta informations extracted from the WSDL
     * - documentation: Specifies the Store configuration that is being set for the user.
     * - minOccurs: 0
     * @var \ebay\StructType\StoreType
     */
    public $Store;
    /**
     * Constructor method for SetStoreRequestType
     * @uses SetStoreRequestType::setStore()
     * @param \ebay\StructType\StoreType $store
     */
    public function __construct(\ebay\StructType\StoreType $store = null)
    {
        $this
            ->setStore($store);
    }
    /**
     * Get Store value
     * @return \ebay\StructType\StoreType|null
     */
    public function getStore()
    {
        return $this->Store;
    }
    /**
     * Set Store value
     * @param \ebay\StructType\StoreType $store
     * @return \ebay\StructType\SetStoreRequestType
     */
    public function setStore(\ebay\StructType\StoreType $store = null)
    {
        $this->Store = $store;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \ebay\StructType\SetStoreRequestType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
