<?php

namespace ebay\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SellingManagerProductType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Describes a Selling Manager Product
 * @subpackage Structs
 * @date 2017-04-07 16
 */
class SellingManagerProductType extends AbstractStructBase
{
    /**
     * The SellingManagerProductDetails
     * Meta informations extracted from the WSDL
     * - documentation: Container for information about the product.
     * - minOccurs: 0
     * @var \ebay\StructType\SellingManagerProductDetailsType
     */
    public $SellingManagerProductDetails;
    /**
     * The SellingManagerTemplateDetailsArray
     * Meta informations extracted from the WSDL
     * - documentation: Contains the list of the seller's templates contained in the product, one SellingManagerTemplateType object per template.
     * - minOccurs: 0
     * @var \ebay\ArrayType\SellingManagerTemplateDetailsArrayType
     */
    public $SellingManagerTemplateDetailsArray;
    /**
     * The SellingManagerProductInventoryStatus
     * Meta informations extracted from the WSDL
     * - documentation: Container for statistics about the product.
     * - minOccurs: 0
     * @var \ebay\StructType\SellingManagerProductInventoryStatusType
     */
    public $SellingManagerProductInventoryStatus;
    /**
     * The SellingManagerProductSpecifics
     * Meta informations extracted from the WSDL
     * - documentation: Specifies an eBay category associated with the product, defines Item Specifics that are relevant to the product, and defines variations available for the product (which may be used to create multivariation listings).
     * - minOccurs: 0
     * @var \ebay\StructType\SellingManagerProductSpecificsType
     */
    public $SellingManagerProductSpecifics;
    /**
     * The any
     * @var \DOMDocument
     */
    public $any;
    /**
     * Constructor method for SellingManagerProductType
     * @uses SellingManagerProductType::setSellingManagerProductDetails()
     * @uses SellingManagerProductType::setSellingManagerTemplateDetailsArray()
     * @uses SellingManagerProductType::setSellingManagerProductInventoryStatus()
     * @uses SellingManagerProductType::setSellingManagerProductSpecifics()
     * @uses SellingManagerProductType::setAny()
     * @param \ebay\StructType\SellingManagerProductDetailsType $sellingManagerProductDetails
     * @param \ebay\ArrayType\SellingManagerTemplateDetailsArrayType $sellingManagerTemplateDetailsArray
     * @param \ebay\StructType\SellingManagerProductInventoryStatusType $sellingManagerProductInventoryStatus
     * @param \ebay\StructType\SellingManagerProductSpecificsType $sellingManagerProductSpecifics
     * @param \DOMDocument $any
     */
    public function __construct(\ebay\StructType\SellingManagerProductDetailsType $sellingManagerProductDetails = null, \ebay\ArrayType\SellingManagerTemplateDetailsArrayType $sellingManagerTemplateDetailsArray = null, \ebay\StructType\SellingManagerProductInventoryStatusType $sellingManagerProductInventoryStatus = null, \ebay\StructType\SellingManagerProductSpecificsType $sellingManagerProductSpecifics = null, \DOMDocument $any = null)
    {
        $this
            ->setSellingManagerProductDetails($sellingManagerProductDetails)
            ->setSellingManagerTemplateDetailsArray($sellingManagerTemplateDetailsArray)
            ->setSellingManagerProductInventoryStatus($sellingManagerProductInventoryStatus)
            ->setSellingManagerProductSpecifics($sellingManagerProductSpecifics)
            ->setAny($any);
    }
    /**
     * Get SellingManagerProductDetails value
     * @return \ebay\StructType\SellingManagerProductDetailsType|null
     */
    public function getSellingManagerProductDetails()
    {
        return $this->SellingManagerProductDetails;
    }
    /**
     * Set SellingManagerProductDetails value
     * @param \ebay\StructType\SellingManagerProductDetailsType $sellingManagerProductDetails
     * @return \ebay\StructType\SellingManagerProductType
     */
    public function setSellingManagerProductDetails(\ebay\StructType\SellingManagerProductDetailsType $sellingManagerProductDetails = null)
    {
        $this->SellingManagerProductDetails = $sellingManagerProductDetails;
        return $this;
    }
    /**
     * Get SellingManagerTemplateDetailsArray value
     * @return \ebay\ArrayType\SellingManagerTemplateDetailsArrayType|null
     */
    public function getSellingManagerTemplateDetailsArray()
    {
        return $this->SellingManagerTemplateDetailsArray;
    }
    /**
     * Set SellingManagerTemplateDetailsArray value
     * @param \ebay\ArrayType\SellingManagerTemplateDetailsArrayType $sellingManagerTemplateDetailsArray
     * @return \ebay\StructType\SellingManagerProductType
     */
    public function setSellingManagerTemplateDetailsArray(\ebay\ArrayType\SellingManagerTemplateDetailsArrayType $sellingManagerTemplateDetailsArray = null)
    {
        $this->SellingManagerTemplateDetailsArray = $sellingManagerTemplateDetailsArray;
        return $this;
    }
    /**
     * Get SellingManagerProductInventoryStatus value
     * @return \ebay\StructType\SellingManagerProductInventoryStatusType|null
     */
    public function getSellingManagerProductInventoryStatus()
    {
        return $this->SellingManagerProductInventoryStatus;
    }
    /**
     * Set SellingManagerProductInventoryStatus value
     * @param \ebay\StructType\SellingManagerProductInventoryStatusType $sellingManagerProductInventoryStatus
     * @return \ebay\StructType\SellingManagerProductType
     */
    public function setSellingManagerProductInventoryStatus(\ebay\StructType\SellingManagerProductInventoryStatusType $sellingManagerProductInventoryStatus = null)
    {
        $this->SellingManagerProductInventoryStatus = $sellingManagerProductInventoryStatus;
        return $this;
    }
    /**
     * Get SellingManagerProductSpecifics value
     * @return \ebay\StructType\SellingManagerProductSpecificsType|null
     */
    public function getSellingManagerProductSpecifics()
    {
        return $this->SellingManagerProductSpecifics;
    }
    /**
     * Set SellingManagerProductSpecifics value
     * @param \ebay\StructType\SellingManagerProductSpecificsType $sellingManagerProductSpecifics
     * @return \ebay\StructType\SellingManagerProductType
     */
    public function setSellingManagerProductSpecifics(\ebay\StructType\SellingManagerProductSpecificsType $sellingManagerProductSpecifics = null)
    {
        $this->SellingManagerProductSpecifics = $sellingManagerProductSpecifics;
        return $this;
    }
    /**
     * Get any value
     * @uses \DOMDocument::loadXML()
     * @uses \DOMDocument::hasChildNodes()
     * @uses \DOMDocument::saveXML()
     * @uses \DOMNode::item()
     * @uses \ebay\StructType\SellingManagerProductType::setAny()
     * @param bool $asString true: returns XML string, false: returns \DOMDocument
     * @return \DOMDocument|null
     */
    public function getAny($asString = true)
    {
        if (!empty($this->any) && !($this->any instanceof \DOMDocument)) {
            $dom = new \DOMDocument('1.0', 'UTF-8');
            $dom->formatOutput = true;
            if ($dom->loadXML($this->any)) {
                $this->setAny($dom);
            }
            unset($dom);
        }
        return ($asString && ($this->any instanceof \DOMDocument) && $this->any->hasChildNodes()) ? $this->any->saveXML($this->any->childNodes->item(0)) : $this->any;
    }
    /**
     * Set any value
     * @param \DOMDocument $any
     * @return \ebay\StructType\SellingManagerProductType
     */
    public function setAny(\DOMDocument $any = null)
    {
        $this->any = $any;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \ebay\StructType\SellingManagerProductType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
