<?php

namespace ebay\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReviseItemRequestType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Enables a seller to change the properties of a currently active listing.&nbsp;<b>Also for Half.com</b>. <br> <br> After one item in a multi-quantity fixed-price listing has been sold, you can not the values in the Title, Primary
 * Category, Secondary Category, Listing Duration, and Listing Type fields for that listing. However, all other fields in the multi-quantity, fixed-price listing are editable. <br> <br> Inputs are the Item ID of the listing you are revising, and the
 * field or fields that you are updating.
 * @subpackage Structs
 * @date 2017-04-07 16
 */
class ReviseItemRequestType extends AbstractRequestType
{
    /**
     * The Item
     * Meta informations extracted from the WSDL
     * - documentation: Child elements hold the values for properties that are changing. The Item.ItemID property must always be set to the ID of the item listing being changed. Set values in the Item object only for those properties that are changing. Use
     * DeletedField to remove a property. <br><br> Applicable to Half.com.
     * - minOccurs: 0
     * @var \ebay\StructType\ItemType
     */
    public $Item;
    /**
     * The DeletedField
     * Meta informations extracted from the WSDL
     * - documentation: Specifies the name of a field to delete from a listing. See the eBay Features Guide for rules on deleting values when revising items. Also see the relevant field descriptions to determine when to use DeletedField (and potential
     * consequences). The request can contain zero, one, or many instances of DeletedField (one for each field to be deleted). <br><br> You cannot delete required fields from a listing. <br><br> Some fields are optional when you first list an item (e.g.,
     * SecondaryCategory), but once they are set they cannot be deleted when you revise an item. Some optional fields cannot be deleted from auction listings if the item has bids and/or ends within 12 hours. Some optional fields cannot be deleted if other
     * fields depend on them. <br><br> Some data (such as Variation nodes within Variations) can't be deleted by using DeletedFields. See the relevant field descriptions for how to delete such data. See the eBay Features Guide for rules on removing values
     * when revising items. Also see the relevant field descriptions for details on when to use DeletedField (and potential consequences). <br><br> Use values that match the case of the schema element names (Item.PictureDetails.GalleryURL) or make the
     * initial letter of each field name lowercase (item.pictureDetails.galleryURL). However, do not change the case of letters in the middle of a field name. For example, item.picturedetails.galleryUrl is not allowed. <br><br> To delete a listing
     * enhancement like BoldTitle, specify the value you are deleting in square brackets ("[ ]"); for example, Item.ListingEnhancement[BoldTitle].
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $DeletedField;
    /**
     * The VerifyOnly
     * Meta informations extracted from the WSDL
     * - documentation: When the VerifyOnly boolean tag value is supplied as 'true', the response will include the calculated listing price change if there is an increase in the BIN/Start price, but does not persist the values in DB. This call is similar to
     * VerifyAddItem in revise mode.
     * - minOccurs: 0
     * @var bool
     */
    public $VerifyOnly;
    /**
     * Constructor method for ReviseItemRequestType
     * @uses ReviseItemRequestType::setItem()
     * @uses ReviseItemRequestType::setDeletedField()
     * @uses ReviseItemRequestType::setVerifyOnly()
     * @param \ebay\StructType\ItemType $item
     * @param string[] $deletedField
     * @param bool $verifyOnly
     */
    public function __construct(\ebay\StructType\ItemType $item = null, array $deletedField = array(), $verifyOnly = null)
    {
        $this
            ->setItem($item)
            ->setDeletedField($deletedField)
            ->setVerifyOnly($verifyOnly);
    }
    /**
     * Get Item value
     * @return \ebay\StructType\ItemType|null
     */
    public function getItem()
    {
        return $this->Item;
    }
    /**
     * Set Item value
     * @param \ebay\StructType\ItemType $item
     * @return \ebay\StructType\ReviseItemRequestType
     */
    public function setItem(\ebay\StructType\ItemType $item = null)
    {
        $this->Item = $item;
        return $this;
    }
    /**
     * Get DeletedField value
     * @return string[]|null
     */
    public function getDeletedField()
    {
        return $this->DeletedField;
    }
    /**
     * Set DeletedField value
     * @throws \InvalidArgumentException
     * @param string[] $deletedField
     * @return \ebay\StructType\ReviseItemRequestType
     */
    public function setDeletedField(array $deletedField = array())
    {
        foreach ($deletedField as $reviseItemRequestTypeDeletedFieldItem) {
            // validation for constraint: itemType
            if (!is_string($reviseItemRequestTypeDeletedFieldItem)) {
                throw new \InvalidArgumentException(sprintf('The DeletedField property can only contain items of string, "%s" given', is_object($reviseItemRequestTypeDeletedFieldItem) ? get_class($reviseItemRequestTypeDeletedFieldItem) : gettype($reviseItemRequestTypeDeletedFieldItem)), __LINE__);
            }
        }
        $this->DeletedField = $deletedField;
        return $this;
    }
    /**
     * Add item to DeletedField value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \ebay\StructType\ReviseItemRequestType
     */
    public function addToDeletedField($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The DeletedField property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->DeletedField[] = $item;
        return $this;
    }
    /**
     * Get VerifyOnly value
     * @return bool|null
     */
    public function getVerifyOnly()
    {
        return $this->VerifyOnly;
    }
    /**
     * Set VerifyOnly value
     * @param bool $verifyOnly
     * @return \ebay\StructType\ReviseItemRequestType
     */
    public function setVerifyOnly($verifyOnly = null)
    {
        $this->VerifyOnly = $verifyOnly;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \ebay\StructType\ReviseItemRequestType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
