<?php

namespace ebay\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RemoveFromWatchListRequestType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Enables a user to remove one or more items from their My eBay watch list.
 * @subpackage Structs
 * @date 2017-04-07 16
 */
class RemoveFromWatchListRequestType extends AbstractRequestType
{
    /**
     * The ItemID
     * Meta informations extracted from the WSDL
     * - documentation: The ID of the item to be removed from the watch list. Either ItemID, RemoveAllItems, or VariationKey must be specified, but NOT more than one of these. Multiple ItemID fields can be specified in the same request. | Type that
     * represents the unique identifier for a single item listing.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $ItemID;
    /**
     * The RemoveAllItems
     * Meta informations extracted from the WSDL
     * - documentation: If true, then all the items in the user's watch list are removed. Either ItemID, RemoveAllItems, or VariationKey must be specified, but NOT more than one of these.
     * - minOccurs: 0
     * @var bool
     */
    public $RemoveAllItems;
    /**
     * The VariationKey
     * Meta informations extracted from the WSDL
     * - documentation: A variation (or set of variations) that you want to remove from the watch list. Either ItemID, RemoveAllItems, or VariationKey must be specified, but NOT more than one of these.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \ebay\StructType\VariationKeyType[]
     */
    public $VariationKey;
    /**
     * Constructor method for RemoveFromWatchListRequestType
     * @uses RemoveFromWatchListRequestType::setItemID()
     * @uses RemoveFromWatchListRequestType::setRemoveAllItems()
     * @uses RemoveFromWatchListRequestType::setVariationKey()
     * @param string[] $itemID
     * @param bool $removeAllItems
     * @param \ebay\StructType\VariationKeyType[] $variationKey
     */
    public function __construct(array $itemID = array(), $removeAllItems = null, array $variationKey = array())
    {
        $this
            ->setItemID($itemID)
            ->setRemoveAllItems($removeAllItems)
            ->setVariationKey($variationKey);
    }
    /**
     * Get ItemID value
     * @return string[]|null
     */
    public function getItemID()
    {
        return $this->ItemID;
    }
    /**
     * Set ItemID value
     * @throws \InvalidArgumentException
     * @param string[] $itemID
     * @return \ebay\StructType\RemoveFromWatchListRequestType
     */
    public function setItemID(array $itemID = array())
    {
        foreach ($itemID as $removeFromWatchListRequestTypeItemIDItem) {
            // validation for constraint: itemType
            if (!is_string($removeFromWatchListRequestTypeItemIDItem)) {
                throw new \InvalidArgumentException(sprintf('The ItemID property can only contain items of string, "%s" given', is_object($removeFromWatchListRequestTypeItemIDItem) ? get_class($removeFromWatchListRequestTypeItemIDItem) : gettype($removeFromWatchListRequestTypeItemIDItem)), __LINE__);
            }
        }
        $this->ItemID = $itemID;
        return $this;
    }
    /**
     * Add item to ItemID value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \ebay\StructType\RemoveFromWatchListRequestType
     */
    public function addToItemID($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The ItemID property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ItemID[] = $item;
        return $this;
    }
    /**
     * Get RemoveAllItems value
     * @return bool|null
     */
    public function getRemoveAllItems()
    {
        return $this->RemoveAllItems;
    }
    /**
     * Set RemoveAllItems value
     * @param bool $removeAllItems
     * @return \ebay\StructType\RemoveFromWatchListRequestType
     */
    public function setRemoveAllItems($removeAllItems = null)
    {
        $this->RemoveAllItems = $removeAllItems;
        return $this;
    }
    /**
     * Get VariationKey value
     * @return \ebay\StructType\VariationKeyType[]|null
     */
    public function getVariationKey()
    {
        return $this->VariationKey;
    }
    /**
     * Set VariationKey value
     * @throws \InvalidArgumentException
     * @param \ebay\StructType\VariationKeyType[] $variationKey
     * @return \ebay\StructType\RemoveFromWatchListRequestType
     */
    public function setVariationKey(array $variationKey = array())
    {
        foreach ($variationKey as $removeFromWatchListRequestTypeVariationKeyItem) {
            // validation for constraint: itemType
            if (!$removeFromWatchListRequestTypeVariationKeyItem instanceof \ebay\StructType\VariationKeyType) {
                throw new \InvalidArgumentException(sprintf('The VariationKey property can only contain items of \ebay\StructType\VariationKeyType, "%s" given', is_object($removeFromWatchListRequestTypeVariationKeyItem) ? get_class($removeFromWatchListRequestTypeVariationKeyItem) : gettype($removeFromWatchListRequestTypeVariationKeyItem)), __LINE__);
            }
        }
        $this->VariationKey = $variationKey;
        return $this;
    }
    /**
     * Add item to VariationKey value
     * @throws \InvalidArgumentException
     * @param \ebay\StructType\VariationKeyType $item
     * @return \ebay\StructType\RemoveFromWatchListRequestType
     */
    public function addToVariationKey(\ebay\StructType\VariationKeyType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \ebay\StructType\VariationKeyType) {
            throw new \InvalidArgumentException(sprintf('The VariationKey property can only contain items of \ebay\StructType\VariationKeyType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->VariationKey[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \ebay\StructType\RemoveFromWatchListRequestType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
