<?php

namespace ebay\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RecoupmentPolicyConsentType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Container for supported site information
 * @subpackage Structs
 * @date 2017-04-07 16
 */
class RecoupmentPolicyConsentType extends AbstractStructBase
{
    /**
     * The Site
     * Meta informations extracted from the WSDL
     * - documentation: Site codes for sites where the Seller has agreed to cross-border trade recoupment. This means that the site where the seller is trading requires a recoupment agreement for cross-border trade, and the seller has an agreement in
     * effect.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $Site;
    /**
     * The any
     * @var \DOMDocument
     */
    public $any;
    /**
     * Constructor method for RecoupmentPolicyConsentType
     * @uses RecoupmentPolicyConsentType::setSite()
     * @uses RecoupmentPolicyConsentType::setAny()
     * @param string[] $site
     * @param \DOMDocument $any
     */
    public function __construct(array $site = array(), \DOMDocument $any = null)
    {
        $this
            ->setSite($site)
            ->setAny($any);
    }
    /**
     * Get Site value
     * @return string[]|null
     */
    public function getSite()
    {
        return $this->Site;
    }
    /**
     * Set Site value
     * @uses \ebay\EnumType\SiteCodeType::valueIsValid()
     * @uses \ebay\EnumType\SiteCodeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $site
     * @return \ebay\StructType\RecoupmentPolicyConsentType
     */
    public function setSite(array $site = array())
    {
        $invalidValues = array();
        foreach ($site as $recoupmentPolicyConsentTypeSiteItem) {
            if (!\ebay\EnumType\SiteCodeType::valueIsValid($recoupmentPolicyConsentTypeSiteItem)) {
                $invalidValues[] = var_export($recoupmentPolicyConsentTypeSiteItem);
            }
        }
        if (!empty($invalidValues)) {
            throw new \InvalidArgumentException(sprintf('Value(s) "%s" is/are invalid, please use one of: %s', implode(', ', $invalidValues), implode(', ', \ebay\EnumType\SiteCodeType::getValidValues())), __LINE__);
        }
        $this->Site = $site;
        return $this;
    }
    /**
     * Add item to Site value
     * @uses \ebay\EnumType\SiteCodeType::valueIsValid()
     * @uses \ebay\EnumType\SiteCodeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \ebay\StructType\RecoupmentPolicyConsentType
     */
    public function addToSite($item)
    {
        // validation for constraint: enumeration
        if (!\ebay\EnumType\SiteCodeType::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $item, implode(', ', \ebay\EnumType\SiteCodeType::getValidValues())), __LINE__);
        }
        $this->Site[] = $item;
        return $this;
    }
    /**
     * Get any value
     * @uses \DOMDocument::loadXML()
     * @uses \DOMDocument::hasChildNodes()
     * @uses \DOMDocument::saveXML()
     * @uses \DOMNode::item()
     * @uses \ebay\StructType\RecoupmentPolicyConsentType::setAny()
     * @param bool $asString true: returns XML string, false: returns \DOMDocument
     * @return \DOMDocument|null
     */
    public function getAny($asString = true)
    {
        if (!empty($this->any) && !($this->any instanceof \DOMDocument)) {
            $dom = new \DOMDocument('1.0', 'UTF-8');
            $dom->formatOutput = true;
            if ($dom->loadXML($this->any)) {
                $this->setAny($dom);
            }
            unset($dom);
        }
        return ($asString && ($this->any instanceof \DOMDocument) && $this->any->hasChildNodes()) ? $this->any->saveXML($this->any->childNodes->item(0)) : $this->any;
    }
    /**
     * Set any value
     * @param \DOMDocument $any
     * @return \ebay\StructType\RecoupmentPolicyConsentType
     */
    public function setAny(\DOMDocument $any = null)
    {
        $this->any = $any;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \ebay\StructType\RecoupmentPolicyConsentType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
