<?php

namespace ebay\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaymentInformationType StructType
 * Meta informations extracted from the WSDL
 * - documentation: This type contains information about the way a buyer payment is allocated for a specified order.
 * @subpackage Structs
 * @date 2017-04-07 16
 */
class PaymentInformationType extends AbstractStructBase
{
    /**
     * The Payment
     * Meta informations extracted from the WSDL
     * - documentation: Contains information about the funds allocated to one payee from a buyer payment for a specified order.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \ebay\StructType\PaymentTransactionType[]
     */
    public $Payment;
    /**
     * The any
     * @var \DOMDocument
     */
    public $any;
    /**
     * Constructor method for PaymentInformationType
     * @uses PaymentInformationType::setPayment()
     * @uses PaymentInformationType::setAny()
     * @param \ebay\StructType\PaymentTransactionType[] $payment
     * @param \DOMDocument $any
     */
    public function __construct(array $payment = array(), \DOMDocument $any = null)
    {
        $this
            ->setPayment($payment)
            ->setAny($any);
    }
    /**
     * Get Payment value
     * @return \ebay\StructType\PaymentTransactionType[]|null
     */
    public function getPayment()
    {
        return $this->Payment;
    }
    /**
     * Set Payment value
     * @throws \InvalidArgumentException
     * @param \ebay\StructType\PaymentTransactionType[] $payment
     * @return \ebay\StructType\PaymentInformationType
     */
    public function setPayment(array $payment = array())
    {
        foreach ($payment as $paymentInformationTypePaymentItem) {
            // validation for constraint: itemType
            if (!$paymentInformationTypePaymentItem instanceof \ebay\StructType\PaymentTransactionType) {
                throw new \InvalidArgumentException(sprintf('The Payment property can only contain items of \ebay\StructType\PaymentTransactionType, "%s" given', is_object($paymentInformationTypePaymentItem) ? get_class($paymentInformationTypePaymentItem) : gettype($paymentInformationTypePaymentItem)), __LINE__);
            }
        }
        $this->Payment = $payment;
        return $this;
    }
    /**
     * Add item to Payment value
     * @throws \InvalidArgumentException
     * @param \ebay\StructType\PaymentTransactionType $item
     * @return \ebay\StructType\PaymentInformationType
     */
    public function addToPayment(\ebay\StructType\PaymentTransactionType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \ebay\StructType\PaymentTransactionType) {
            throw new \InvalidArgumentException(sprintf('The Payment property can only contain items of \ebay\StructType\PaymentTransactionType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Payment[] = $item;
        return $this;
    }
    /**
     * Get any value
     * @uses \DOMDocument::loadXML()
     * @uses \DOMDocument::hasChildNodes()
     * @uses \DOMDocument::saveXML()
     * @uses \DOMNode::item()
     * @uses \ebay\StructType\PaymentInformationType::setAny()
     * @param bool $asString true: returns XML string, false: returns \DOMDocument
     * @return \DOMDocument|null
     */
    public function getAny($asString = true)
    {
        if (!empty($this->any) && !($this->any instanceof \DOMDocument)) {
            $dom = new \DOMDocument('1.0', 'UTF-8');
            $dom->formatOutput = true;
            if ($dom->loadXML($this->any)) {
                $this->setAny($dom);
            }
            unset($dom);
        }
        return ($asString && ($this->any instanceof \DOMDocument) && $this->any->hasChildNodes()) ? $this->any->saveXML($this->any->childNodes->item(0)) : $this->any;
    }
    /**
     * Set any value
     * @param \DOMDocument $any
     * @return \ebay\StructType\PaymentInformationType
     */
    public function setAny(\DOMDocument $any = null)
    {
        $this->any = $any;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \ebay\StructType\PaymentInformationType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
