<?php

namespace ebay\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for IssueRefundResponseType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Indicates the refund amount that a seller issued to a buyer for a single Half.com order line item. Refunds may only be issued for a specific order line item. Sellers do not have the ability to issue a general refund (not tied to an
 * order line item) to a buyer.
 * @subpackage Structs
 * @date 2017-04-07 16
 */
class IssueRefundResponseType extends AbstractResponseType
{
    /**
     * The RefundFromSeller
     * Meta informations extracted from the WSDL
     * - documentation: Total amount that the seller asked Half.com to refund to a buyer for a Half.com order line item.
     * - minOccurs: 0
     * @var \ebay\StructType\AmountType
     */
    public $RefundFromSeller;
    /**
     * The TotalRefundToBuyer
     * Meta informations extracted from the WSDL
     * - documentation: Total amount that Half.com refunded to the buyer (which could include the refund amount from the seller plus a refund amount from Half.com).
     * - minOccurs: 0
     * @var \ebay\StructType\AmountType
     */
    public $TotalRefundToBuyer;
    /**
     * Constructor method for IssueRefundResponseType
     * @uses IssueRefundResponseType::setRefundFromSeller()
     * @uses IssueRefundResponseType::setTotalRefundToBuyer()
     * @param \ebay\StructType\AmountType $refundFromSeller
     * @param \ebay\StructType\AmountType $totalRefundToBuyer
     */
    public function __construct(\ebay\StructType\AmountType $refundFromSeller = null, \ebay\StructType\AmountType $totalRefundToBuyer = null)
    {
        $this
            ->setRefundFromSeller($refundFromSeller)
            ->setTotalRefundToBuyer($totalRefundToBuyer);
    }
    /**
     * Get RefundFromSeller value
     * @return \ebay\StructType\AmountType|null
     */
    public function getRefundFromSeller()
    {
        return $this->RefundFromSeller;
    }
    /**
     * Set RefundFromSeller value
     * @param \ebay\StructType\AmountType $refundFromSeller
     * @return \ebay\StructType\IssueRefundResponseType
     */
    public function setRefundFromSeller(\ebay\StructType\AmountType $refundFromSeller = null)
    {
        $this->RefundFromSeller = $refundFromSeller;
        return $this;
    }
    /**
     * Get TotalRefundToBuyer value
     * @return \ebay\StructType\AmountType|null
     */
    public function getTotalRefundToBuyer()
    {
        return $this->TotalRefundToBuyer;
    }
    /**
     * Set TotalRefundToBuyer value
     * @param \ebay\StructType\AmountType $totalRefundToBuyer
     * @return \ebay\StructType\IssueRefundResponseType
     */
    public function setTotalRefundToBuyer(\ebay\StructType\AmountType $totalRefundToBuyer = null)
    {
        $this->TotalRefundToBuyer = $totalRefundToBuyer;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \ebay\StructType\IssueRefundResponseType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
