<?php

namespace ebay\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for IssueRefundRequestType StructType
 * Meta informations extracted from the WSDL
 * - documentation: <b>Half.com only.</b>&nbsp;Issues a refund for a specific Half.com order line item. This can only be called by a seller. Sellers do not have the ability to issue a general refund (a refund not tied to an order line item) to a buyer.
 * @subpackage Structs
 * @date 2017-04-07 16
 */
class IssueRefundRequestType extends AbstractRequestType
{
    /**
     * The ItemID
     * Meta informations extracted from the WSDL
     * - documentation: Unique identifier for the Half.com item listing. Unless an <b>OrderLineItemID</b> is specified in the <b>IssueRefund</b> request, the <b>ItemID</b> is required along with the corresponding <b>TransactionID</b> to identify the order
     * line item that will be refunded. You can use <b>GetSellerPayments</b> to retrieve the <b>ItemID</b> and/or <b>TransactionID</b> associated with the order line item. | Type that represents the unique identifier for a single item listing.
     * - minOccurs: 0
     * @var string
     */
    public $ItemID;
    /**
     * The TransactionID
     * Meta informations extracted from the WSDL
     * - documentation: Unique identifier for a Half.com order line item (transaction). An order line item is created once there is a commitment from a buyer to purchase an item. Along with its corresponding <b>ItemID</b>, a <b>TransactionID</b> is used to
     * identify the order line item that will be refunded. Unless an <b>OrderLineItemID</b> is specified in the <b>IssueRefund</b> request, the <b>TransactionID</b> is required along with the corresponding <b>ItemID</b>. You can use <b>GetSellerPayments</b>
     * to retrieve the <b>ItemID</b> and/or <b>TransactionID</b> associated with the order line item.
     * - minOccurs: 0
     * @var string
     */
    public $TransactionID;
    /**
     * The RefundReason
     * Meta informations extracted from the WSDL
     * - documentation: Explanation of the reason that the refund is being issued.
     * - minOccurs: 0
     * @var string
     */
    public $RefundReason;
    /**
     * The RefundType
     * Meta informations extracted from the WSDL
     * - documentation: Explanation of the costs that the refund amount covers.
     * - minOccurs: 0
     * @var string
     */
    public $RefundType;
    /**
     * The RefundAmount
     * Meta informations extracted from the WSDL
     * - documentation: The amount the seller wants to refund to the buyer, in US Dollars (USD). Must be greater than 0.00. Half.com allows a maximum of the original item sale price (order line item price plus original shipping reimbursement) plus return
     * shipping costs (the amount the buyer paid to return the item). Typically, the return shipping cost is based on the current cost of shipping the individual item (not the discounted cost calculated during the original checkout for a Combined Payment
     * order). You can also issue a partial refund for the amount you want the buyer to receive. If RefundType=Full or RefundType=FullPlusShipping and you do not pass <b>RefundAmount</b> in the request, Half.com will calculate the refund amount for you. If
     * you pass <b>RefundAmount</b> in the request, the amount you specify will override Half.com's calculated value. Required if RefundType= CustomOrPartial.
     * - minOccurs: 0
     * @var \ebay\StructType\AmountType
     */
    public $RefundAmount;
    /**
     * The RefundMessage
     * Meta informations extracted from the WSDL
     * - documentation: Note to the buyer. Cannot include HTML.
     * - minOccurs: 0
     * @var string
     */
    public $RefundMessage;
    /**
     * The OrderLineItemID
     * Meta informations extracted from the WSDL
     * - documentation: A unique identifier for an eBay order line item. This field is created as soon as there is a commitment to buy from the seller, and its value is based upon the concatenation of <b>ItemID</b> and <b>TransactionID</b>, with a hyphen in
     * between these two IDs. The <b>OrderLineItemID</b> value is used to identify the order line item that will be refunded. Unless an <b>ItemID</b>/<b>TransactionID</b> pair is specified in the <b>IssueRefund</b> request, the <b>OrderLineItemID</b> is
     * required. You can use <b>GetSellerPayments</b> to retrieve the <b>OrderLineItemID</b> associated with the order line item. <br>
     * - minOccurs: 0
     * @var string
     */
    public $OrderLineItemID;
    /**
     * Constructor method for IssueRefundRequestType
     * @uses IssueRefundRequestType::setItemID()
     * @uses IssueRefundRequestType::setTransactionID()
     * @uses IssueRefundRequestType::setRefundReason()
     * @uses IssueRefundRequestType::setRefundType()
     * @uses IssueRefundRequestType::setRefundAmount()
     * @uses IssueRefundRequestType::setRefundMessage()
     * @uses IssueRefundRequestType::setOrderLineItemID()
     * @param string $itemID
     * @param string $transactionID
     * @param string $refundReason
     * @param string $refundType
     * @param \ebay\StructType\AmountType $refundAmount
     * @param string $refundMessage
     * @param string $orderLineItemID
     */
    public function __construct($itemID = null, $transactionID = null, $refundReason = null, $refundType = null, \ebay\StructType\AmountType $refundAmount = null, $refundMessage = null, $orderLineItemID = null)
    {
        $this
            ->setItemID($itemID)
            ->setTransactionID($transactionID)
            ->setRefundReason($refundReason)
            ->setRefundType($refundType)
            ->setRefundAmount($refundAmount)
            ->setRefundMessage($refundMessage)
            ->setOrderLineItemID($orderLineItemID);
    }
    /**
     * Get ItemID value
     * @return string|null
     */
    public function getItemID()
    {
        return $this->ItemID;
    }
    /**
     * Set ItemID value
     * @param string $itemID
     * @return \ebay\StructType\IssueRefundRequestType
     */
    public function setItemID($itemID = null)
    {
        // validation for constraint: string
        if (!is_null($itemID) && !is_string($itemID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($itemID)), __LINE__);
        }
        $this->ItemID = $itemID;
        return $this;
    }
    /**
     * Get TransactionID value
     * @return string|null
     */
    public function getTransactionID()
    {
        return $this->TransactionID;
    }
    /**
     * Set TransactionID value
     * @param string $transactionID
     * @return \ebay\StructType\IssueRefundRequestType
     */
    public function setTransactionID($transactionID = null)
    {
        // validation for constraint: string
        if (!is_null($transactionID) && !is_string($transactionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($transactionID)), __LINE__);
        }
        $this->TransactionID = $transactionID;
        return $this;
    }
    /**
     * Get RefundReason value
     * @return string|null
     */
    public function getRefundReason()
    {
        return $this->RefundReason;
    }
    /**
     * Set RefundReason value
     * @uses \ebay\EnumType\RefundReasonCodeType::valueIsValid()
     * @uses \ebay\EnumType\RefundReasonCodeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $refundReason
     * @return \ebay\StructType\IssueRefundRequestType
     */
    public function setRefundReason($refundReason = null)
    {
        // validation for constraint: enumeration
        if (!\ebay\EnumType\RefundReasonCodeType::valueIsValid($refundReason)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $refundReason, implode(', ', \ebay\EnumType\RefundReasonCodeType::getValidValues())), __LINE__);
        }
        $this->RefundReason = $refundReason;
        return $this;
    }
    /**
     * Get RefundType value
     * @return string|null
     */
    public function getRefundType()
    {
        return $this->RefundType;
    }
    /**
     * Set RefundType value
     * @uses \ebay\EnumType\RefundTypeCodeType::valueIsValid()
     * @uses \ebay\EnumType\RefundTypeCodeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $refundType
     * @return \ebay\StructType\IssueRefundRequestType
     */
    public function setRefundType($refundType = null)
    {
        // validation for constraint: enumeration
        if (!\ebay\EnumType\RefundTypeCodeType::valueIsValid($refundType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $refundType, implode(', ', \ebay\EnumType\RefundTypeCodeType::getValidValues())), __LINE__);
        }
        $this->RefundType = $refundType;
        return $this;
    }
    /**
     * Get RefundAmount value
     * @return \ebay\StructType\AmountType|null
     */
    public function getRefundAmount()
    {
        return $this->RefundAmount;
    }
    /**
     * Set RefundAmount value
     * @param \ebay\StructType\AmountType $refundAmount
     * @return \ebay\StructType\IssueRefundRequestType
     */
    public function setRefundAmount(\ebay\StructType\AmountType $refundAmount = null)
    {
        $this->RefundAmount = $refundAmount;
        return $this;
    }
    /**
     * Get RefundMessage value
     * @return string|null
     */
    public function getRefundMessage()
    {
        return $this->RefundMessage;
    }
    /**
     * Set RefundMessage value
     * @param string $refundMessage
     * @return \ebay\StructType\IssueRefundRequestType
     */
    public function setRefundMessage($refundMessage = null)
    {
        // validation for constraint: string
        if (!is_null($refundMessage) && !is_string($refundMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($refundMessage)), __LINE__);
        }
        $this->RefundMessage = $refundMessage;
        return $this;
    }
    /**
     * Get OrderLineItemID value
     * @return string|null
     */
    public function getOrderLineItemID()
    {
        return $this->OrderLineItemID;
    }
    /**
     * Set OrderLineItemID value
     * @param string $orderLineItemID
     * @return \ebay\StructType\IssueRefundRequestType
     */
    public function setOrderLineItemID($orderLineItemID = null)
    {
        // validation for constraint: string
        if (!is_null($orderLineItemID) && !is_string($orderLineItemID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($orderLineItemID)), __LINE__);
        }
        $this->OrderLineItemID = $orderLineItemID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \ebay\StructType\IssueRefundRequestType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
