<?php

namespace ebay\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetTaxTableResponseType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Response to GetTaxTableRequest.
 * @subpackage Structs
 * @date 2017-04-07 16
 */
class GetTaxTableResponseType extends AbstractResponseType
{
    /**
     * The LastUpdateTime
     * Meta informations extracted from the WSDL
     * - documentation: The last time (in GMT) that the tax table was updated. Only returned if the user previously created a tax table and if the site has jurisdictions. <b>LastUpdateTime</b> is useful for synchronization. If you cache the user's tax
     * table, you can use <b>GetTaxTable</b> to check if it has changed and whether you need to update the cached tax table.
     * - minOccurs: 0
     * @var string
     */
    public $LastUpdateTime;
    /**
     * The TaxTable
     * Meta informations extracted from the WSDL
     * - documentation: A container of tax jurisdiction information unique to a user/site combination. Empty if not set for user. If <b>DetailLevel</b> is not specified, information is only returned for the jurisdictions for which the user provided tax
     * information. If <b>DetailLevel</b> is <b>ReturnAll</b>, tax information is returned for all possible jurisdictions, whether specified by the user or not. <b>ShippingIncludedInTax</b> and <b>SalesTaxPercent</b> are returned but are empty.
     * - minOccurs: 0
     * @var \ebay\StructType\TaxTableType
     */
    public $TaxTable;
    /**
     * Constructor method for GetTaxTableResponseType
     * @uses GetTaxTableResponseType::setLastUpdateTime()
     * @uses GetTaxTableResponseType::setTaxTable()
     * @param string $lastUpdateTime
     * @param \ebay\StructType\TaxTableType $taxTable
     */
    public function __construct($lastUpdateTime = null, \ebay\StructType\TaxTableType $taxTable = null)
    {
        $this
            ->setLastUpdateTime($lastUpdateTime)
            ->setTaxTable($taxTable);
    }
    /**
     * Get LastUpdateTime value
     * @return string|null
     */
    public function getLastUpdateTime()
    {
        return $this->LastUpdateTime;
    }
    /**
     * Set LastUpdateTime value
     * @param string $lastUpdateTime
     * @return \ebay\StructType\GetTaxTableResponseType
     */
    public function setLastUpdateTime($lastUpdateTime = null)
    {
        // validation for constraint: string
        if (!is_null($lastUpdateTime) && !is_string($lastUpdateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastUpdateTime)), __LINE__);
        }
        $this->LastUpdateTime = $lastUpdateTime;
        return $this;
    }
    /**
     * Get TaxTable value
     * @return \ebay\StructType\TaxTableType|null
     */
    public function getTaxTable()
    {
        return $this->TaxTable;
    }
    /**
     * Set TaxTable value
     * @param \ebay\StructType\TaxTableType $taxTable
     * @return \ebay\StructType\GetTaxTableResponseType
     */
    public function setTaxTable(\ebay\StructType\TaxTableType $taxTable = null)
    {
        $this->TaxTable = $taxTable;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \ebay\StructType\GetTaxTableResponseType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
