<?php

namespace ebay\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetStoreResponseType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Returns the data describing a seller's eBay store, including name, description, URL, and other information. The caller making the request must be the owner of an eBay store. If the authenticated caller does not have an eBay store,
 * the response is an error. A successful response contains either the complete store configuration or information about the category hierarchy for the store only.
 * @subpackage Structs
 * @date 2017-04-07 16
 */
class GetStoreResponseType extends AbstractResponseType
{
    /**
     * The Store
     * Meta informations extracted from the WSDL
     * - documentation: The data describing the store configuration.
     * - minOccurs: 0
     * @var \ebay\StructType\StoreType
     */
    public $Store;
    /**
     * Constructor method for GetStoreResponseType
     * @uses GetStoreResponseType::setStore()
     * @param \ebay\StructType\StoreType $store
     */
    public function __construct(\ebay\StructType\StoreType $store = null)
    {
        $this
            ->setStore($store);
    }
    /**
     * Get Store value
     * @return \ebay\StructType\StoreType|null
     */
    public function getStore()
    {
        return $this->Store;
    }
    /**
     * Set Store value
     * @param \ebay\StructType\StoreType $store
     * @return \ebay\StructType\GetStoreResponseType
     */
    public function setStore(\ebay\StructType\StoreType $store = null)
    {
        $this->Store = $store;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \ebay\StructType\GetStoreResponseType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
