<?php

namespace ebay\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetStoreCategoryUpdateStatusResponseType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Returns the store category structure update status, when a prior SetStoreCategories call was processed asynchronously. If a SetStoreCategories request affects many listings, then the category structure changes will be processed
 * asynchronously. If not many listings are affected by category structure changes, the status is returned in the SetStoreCategories response.
 * @subpackage Structs
 * @date 2017-04-07 16
 */
class GetStoreCategoryUpdateStatusResponseType extends AbstractResponseType
{
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - documentation: The status (Pending, InProgress, Complete, or Failed) of an update to the store category structure.
     * - minOccurs: 0
     * @var string
     */
    public $Status;
    /**
     * Constructor method for GetStoreCategoryUpdateStatusResponseType
     * @uses GetStoreCategoryUpdateStatusResponseType::setStatus()
     * @param string $status
     */
    public function __construct($status = null)
    {
        $this
            ->setStatus($status);
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @uses \ebay\EnumType\TaskStatusCodeType::valueIsValid()
     * @uses \ebay\EnumType\TaskStatusCodeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \ebay\StructType\GetStoreCategoryUpdateStatusResponseType
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\ebay\EnumType\TaskStatusCodeType::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $status, implode(', ', \ebay\EnumType\TaskStatusCodeType::getValidValues())), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \ebay\StructType\GetStoreCategoryUpdateStatusResponseType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
