<?php

namespace ebay\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetMyeBaySellingResponseType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Returns summary and detail information about items the user is selling, items scheduled to sell, currently listed, sold, and closed but not sold.
 * @subpackage Structs
 * @date 2017-04-07 16
 */
class GetMyeBaySellingResponseType extends AbstractResponseType
{
    /**
     * The SellingSummary
     * Meta informations extracted from the WSDL
     * - documentation: Contains summary information about the items the user is selling.
     * - minOccurs: 0
     * @var \ebay\StructType\SellingSummaryType
     */
    public $SellingSummary;
    /**
     * The ScheduledList
     * Meta informations extracted from the WSDL
     * - documentation: Contains the items the user has scheduled for sale, but whose listings have not yet started.
     * - minOccurs: 0
     * @var \ebay\StructType\PaginatedItemArrayType
     */
    public $ScheduledList;
    /**
     * The ActiveList
     * Meta informations extracted from the WSDL
     * - documentation: Contains the items the user is selling that have active listings.
     * - minOccurs: 0
     * @var \ebay\StructType\PaginatedItemArrayType
     */
    public $ActiveList;
    /**
     * The SoldList
     * Meta informations extracted from the WSDL
     * - documentation: Contains the items the user has sold.
     * - minOccurs: 0
     * @var \ebay\StructType\PaginatedOrderTransactionArrayType
     */
    public $SoldList;
    /**
     * The UnsoldList
     * Meta informations extracted from the WSDL
     * - documentation: Contains the items whose listings have ended but that have not sold.
     * - minOccurs: 0
     * @var \ebay\StructType\PaginatedItemArrayType
     */
    public $UnsoldList;
    /**
     * The Summary
     * Meta informations extracted from the WSDL
     * - documentation: Contains summary information about the items the user is selling.
     * - minOccurs: 0
     * @var \ebay\StructType\MyeBaySellingSummaryType
     */
    public $Summary;
    /**
     * The BidList
     * Meta informations extracted from the WSDL
     * - documentation: This container is no longer applicable to <b>GetMyeBaySelling</b>.
     * - minOccurs: 0
     * @var \ebay\StructType\PaginatedItemArrayType
     */
    public $BidList;
    /**
     * The DeletedFromSoldList
     * Meta informations extracted from the WSDL
     * - documentation: Contains the items the seller has sold and deleted from My eBay.
     * - minOccurs: 0
     * @var \ebay\StructType\PaginatedOrderTransactionArrayType
     */
    public $DeletedFromSoldList;
    /**
     * The DeletedFromUnsoldList
     * Meta informations extracted from the WSDL
     * - documentation: Contains the items with listings that were ended or did not sell and have been deleted from My eBay.
     * - minOccurs: 0
     * @var \ebay\StructType\PaginatedItemArrayType
     */
    public $DeletedFromUnsoldList;
    /**
     * Constructor method for GetMyeBaySellingResponseType
     * @uses GetMyeBaySellingResponseType::setSellingSummary()
     * @uses GetMyeBaySellingResponseType::setScheduledList()
     * @uses GetMyeBaySellingResponseType::setActiveList()
     * @uses GetMyeBaySellingResponseType::setSoldList()
     * @uses GetMyeBaySellingResponseType::setUnsoldList()
     * @uses GetMyeBaySellingResponseType::setSummary()
     * @uses GetMyeBaySellingResponseType::setBidList()
     * @uses GetMyeBaySellingResponseType::setDeletedFromSoldList()
     * @uses GetMyeBaySellingResponseType::setDeletedFromUnsoldList()
     * @param \ebay\StructType\SellingSummaryType $sellingSummary
     * @param \ebay\StructType\PaginatedItemArrayType $scheduledList
     * @param \ebay\StructType\PaginatedItemArrayType $activeList
     * @param \ebay\StructType\PaginatedOrderTransactionArrayType $soldList
     * @param \ebay\StructType\PaginatedItemArrayType $unsoldList
     * @param \ebay\StructType\MyeBaySellingSummaryType $summary
     * @param \ebay\StructType\PaginatedItemArrayType $bidList
     * @param \ebay\StructType\PaginatedOrderTransactionArrayType $deletedFromSoldList
     * @param \ebay\StructType\PaginatedItemArrayType $deletedFromUnsoldList
     */
    public function __construct(\ebay\StructType\SellingSummaryType $sellingSummary = null, \ebay\StructType\PaginatedItemArrayType $scheduledList = null, \ebay\StructType\PaginatedItemArrayType $activeList = null, \ebay\StructType\PaginatedOrderTransactionArrayType $soldList = null, \ebay\StructType\PaginatedItemArrayType $unsoldList = null, \ebay\StructType\MyeBaySellingSummaryType $summary = null, \ebay\StructType\PaginatedItemArrayType $bidList = null, \ebay\StructType\PaginatedOrderTransactionArrayType $deletedFromSoldList = null, \ebay\StructType\PaginatedItemArrayType $deletedFromUnsoldList = null)
    {
        $this
            ->setSellingSummary($sellingSummary)
            ->setScheduledList($scheduledList)
            ->setActiveList($activeList)
            ->setSoldList($soldList)
            ->setUnsoldList($unsoldList)
            ->setSummary($summary)
            ->setBidList($bidList)
            ->setDeletedFromSoldList($deletedFromSoldList)
            ->setDeletedFromUnsoldList($deletedFromUnsoldList);
    }
    /**
     * Get SellingSummary value
     * @return \ebay\StructType\SellingSummaryType|null
     */
    public function getSellingSummary()
    {
        return $this->SellingSummary;
    }
    /**
     * Set SellingSummary value
     * @param \ebay\StructType\SellingSummaryType $sellingSummary
     * @return \ebay\StructType\GetMyeBaySellingResponseType
     */
    public function setSellingSummary(\ebay\StructType\SellingSummaryType $sellingSummary = null)
    {
        $this->SellingSummary = $sellingSummary;
        return $this;
    }
    /**
     * Get ScheduledList value
     * @return \ebay\StructType\PaginatedItemArrayType|null
     */
    public function getScheduledList()
    {
        return $this->ScheduledList;
    }
    /**
     * Set ScheduledList value
     * @param \ebay\StructType\PaginatedItemArrayType $scheduledList
     * @return \ebay\StructType\GetMyeBaySellingResponseType
     */
    public function setScheduledList(\ebay\StructType\PaginatedItemArrayType $scheduledList = null)
    {
        $this->ScheduledList = $scheduledList;
        return $this;
    }
    /**
     * Get ActiveList value
     * @return \ebay\StructType\PaginatedItemArrayType|null
     */
    public function getActiveList()
    {
        return $this->ActiveList;
    }
    /**
     * Set ActiveList value
     * @param \ebay\StructType\PaginatedItemArrayType $activeList
     * @return \ebay\StructType\GetMyeBaySellingResponseType
     */
    public function setActiveList(\ebay\StructType\PaginatedItemArrayType $activeList = null)
    {
        $this->ActiveList = $activeList;
        return $this;
    }
    /**
     * Get SoldList value
     * @return \ebay\StructType\PaginatedOrderTransactionArrayType|null
     */
    public function getSoldList()
    {
        return $this->SoldList;
    }
    /**
     * Set SoldList value
     * @param \ebay\StructType\PaginatedOrderTransactionArrayType $soldList
     * @return \ebay\StructType\GetMyeBaySellingResponseType
     */
    public function setSoldList(\ebay\StructType\PaginatedOrderTransactionArrayType $soldList = null)
    {
        $this->SoldList = $soldList;
        return $this;
    }
    /**
     * Get UnsoldList value
     * @return \ebay\StructType\PaginatedItemArrayType|null
     */
    public function getUnsoldList()
    {
        return $this->UnsoldList;
    }
    /**
     * Set UnsoldList value
     * @param \ebay\StructType\PaginatedItemArrayType $unsoldList
     * @return \ebay\StructType\GetMyeBaySellingResponseType
     */
    public function setUnsoldList(\ebay\StructType\PaginatedItemArrayType $unsoldList = null)
    {
        $this->UnsoldList = $unsoldList;
        return $this;
    }
    /**
     * Get Summary value
     * @return \ebay\StructType\MyeBaySellingSummaryType|null
     */
    public function getSummary()
    {
        return $this->Summary;
    }
    /**
     * Set Summary value
     * @param \ebay\StructType\MyeBaySellingSummaryType $summary
     * @return \ebay\StructType\GetMyeBaySellingResponseType
     */
    public function setSummary(\ebay\StructType\MyeBaySellingSummaryType $summary = null)
    {
        $this->Summary = $summary;
        return $this;
    }
    /**
     * Get BidList value
     * @return \ebay\StructType\PaginatedItemArrayType|null
     */
    public function getBidList()
    {
        return $this->BidList;
    }
    /**
     * Set BidList value
     * @param \ebay\StructType\PaginatedItemArrayType $bidList
     * @return \ebay\StructType\GetMyeBaySellingResponseType
     */
    public function setBidList(\ebay\StructType\PaginatedItemArrayType $bidList = null)
    {
        $this->BidList = $bidList;
        return $this;
    }
    /**
     * Get DeletedFromSoldList value
     * @return \ebay\StructType\PaginatedOrderTransactionArrayType|null
     */
    public function getDeletedFromSoldList()
    {
        return $this->DeletedFromSoldList;
    }
    /**
     * Set DeletedFromSoldList value
     * @param \ebay\StructType\PaginatedOrderTransactionArrayType $deletedFromSoldList
     * @return \ebay\StructType\GetMyeBaySellingResponseType
     */
    public function setDeletedFromSoldList(\ebay\StructType\PaginatedOrderTransactionArrayType $deletedFromSoldList = null)
    {
        $this->DeletedFromSoldList = $deletedFromSoldList;
        return $this;
    }
    /**
     * Get DeletedFromUnsoldList value
     * @return \ebay\StructType\PaginatedItemArrayType|null
     */
    public function getDeletedFromUnsoldList()
    {
        return $this->DeletedFromUnsoldList;
    }
    /**
     * Set DeletedFromUnsoldList value
     * @param \ebay\StructType\PaginatedItemArrayType $deletedFromUnsoldList
     * @return \ebay\StructType\GetMyeBaySellingResponseType
     */
    public function setDeletedFromUnsoldList(\ebay\StructType\PaginatedItemArrayType $deletedFromUnsoldList = null)
    {
        $this->DeletedFromUnsoldList = $deletedFromUnsoldList;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \ebay\StructType\GetMyeBaySellingResponseType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
