<?php

namespace ebay\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetMyeBaySellingRequestType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Retrieves information regarding the user's selling activity, such as items that the user is currently selling (the Active list), items that have bids, sold items, and unsold items.
 * @subpackage Structs
 * @date 2017-04-07 16
 */
class GetMyeBaySellingRequestType extends AbstractRequestType
{
    /**
     * The ScheduledList
     * Meta informations extracted from the WSDL
     * - documentation: Returns the list of items the user has scheduled to sell but whose listings have not yet opened. <br><br> Set <b>Include</b> to <code>true</code> to return the default response set.
     * - minOccurs: 0
     * @var \ebay\StructType\ItemListCustomizationType
     */
    public $ScheduledList;
    /**
     * The ActiveList
     * Meta informations extracted from the WSDL
     * - documentation: Returns the list of items the user is actively selling (the currently active listings). <br><br> Set <b>Include</b> to <code>true</code> to return the default response set.
     * - minOccurs: 0
     * @var \ebay\StructType\ItemListCustomizationType
     */
    public $ActiveList;
    /**
     * The SoldList
     * Meta informations extracted from the WSDL
     * - documentation: Returns the list of items the user has sold. <br><br> Set <b>Include</b> to <code>true</code> to return the default response set.
     * - minOccurs: 0
     * @var \ebay\StructType\ItemListCustomizationType
     */
    public $SoldList;
    /**
     * The UnsoldList
     * Meta informations extracted from the WSDL
     * - documentation: Returns the list of items the user has listed, but whose listings have ended without being sold. <br><br> Set <b>Include</b> to <code>true</code> to return the default response set.
     * - minOccurs: 0
     * @var \ebay\StructType\ItemListCustomizationType
     */
    public $UnsoldList;
    /**
     * The BidList
     * Meta informations extracted from the WSDL
     * - documentation: Return the list of active items on which there are bids. <br><br> Set Include to true to return the default response set.
     * - minOccurs: 0
     * @var \ebay\StructType\ItemListCustomizationType
     */
    public $BidList;
    /**
     * The DeletedFromSoldList
     * Meta informations extracted from the WSDL
     * - documentation: Returns the list of items the user sold, and then deleted from their My eBay page. Allowed values for DurationInDays are 0-90. <br><br> Set <b>Include</b> to <code>true</code> to return the default response set.
     * - minOccurs: 0
     * @var \ebay\StructType\ItemListCustomizationType
     */
    public $DeletedFromSoldList;
    /**
     * The DeletedFromUnsoldList
     * Meta informations extracted from the WSDL
     * - documentation: Returns the list of items the user either ended or did not sell, and subsequently were deleted them from their My eBay page. Allowed values for DurationInDays are 0-90. <br><br> Set <b>Include</b> to <code>true</code> to return the
     * default response set.
     * - minOccurs: 0
     * @var \ebay\StructType\ItemListCustomizationType
     */
    public $DeletedFromUnsoldList;
    /**
     * The SellingSummary
     * Meta informations extracted from the WSDL
     * - documentation: Returns a summary of the user's buying activity. <br><br> The <b>SellingSummary</b> is always returned by default. Add a <b>SellingSummary</b> element with an <b>Include</b> field set to false to exclude the <b>SellingSummary</b>
     * from your response.
     * - minOccurs: 0
     * @var \ebay\StructType\ItemListCustomizationType
     */
    public $SellingSummary;
    /**
     * The HideVariations
     * Meta informations extracted from the WSDL
     * - documentation: If true, the <b>Variations</b> node is omitted for all multi-variation listings in the response. If false, the <b>Variations</b> node is returned for all multi-variation listings in the response. <br> <br> Please note that if the
     * seller includes a large number of variations in many listings, retrieving variations (setting this flag to <code>false</code>) may degrade the call's performance. Therefore, when this is false, you may need to reduce the total number of items you're
     * requesting at once (by using other input fields, such as <b>Pagination</b>).
     * - minOccurs: 0
     * @var bool
     */
    public $HideVariations;
    /**
     * Constructor method for GetMyeBaySellingRequestType
     * @uses GetMyeBaySellingRequestType::setScheduledList()
     * @uses GetMyeBaySellingRequestType::setActiveList()
     * @uses GetMyeBaySellingRequestType::setSoldList()
     * @uses GetMyeBaySellingRequestType::setUnsoldList()
     * @uses GetMyeBaySellingRequestType::setBidList()
     * @uses GetMyeBaySellingRequestType::setDeletedFromSoldList()
     * @uses GetMyeBaySellingRequestType::setDeletedFromUnsoldList()
     * @uses GetMyeBaySellingRequestType::setSellingSummary()
     * @uses GetMyeBaySellingRequestType::setHideVariations()
     * @param \ebay\StructType\ItemListCustomizationType $scheduledList
     * @param \ebay\StructType\ItemListCustomizationType $activeList
     * @param \ebay\StructType\ItemListCustomizationType $soldList
     * @param \ebay\StructType\ItemListCustomizationType $unsoldList
     * @param \ebay\StructType\ItemListCustomizationType $bidList
     * @param \ebay\StructType\ItemListCustomizationType $deletedFromSoldList
     * @param \ebay\StructType\ItemListCustomizationType $deletedFromUnsoldList
     * @param \ebay\StructType\ItemListCustomizationType $sellingSummary
     * @param bool $hideVariations
     */
    public function __construct(\ebay\StructType\ItemListCustomizationType $scheduledList = null, \ebay\StructType\ItemListCustomizationType $activeList = null, \ebay\StructType\ItemListCustomizationType $soldList = null, \ebay\StructType\ItemListCustomizationType $unsoldList = null, \ebay\StructType\ItemListCustomizationType $bidList = null, \ebay\StructType\ItemListCustomizationType $deletedFromSoldList = null, \ebay\StructType\ItemListCustomizationType $deletedFromUnsoldList = null, \ebay\StructType\ItemListCustomizationType $sellingSummary = null, $hideVariations = null)
    {
        $this
            ->setScheduledList($scheduledList)
            ->setActiveList($activeList)
            ->setSoldList($soldList)
            ->setUnsoldList($unsoldList)
            ->setBidList($bidList)
            ->setDeletedFromSoldList($deletedFromSoldList)
            ->setDeletedFromUnsoldList($deletedFromUnsoldList)
            ->setSellingSummary($sellingSummary)
            ->setHideVariations($hideVariations);
    }
    /**
     * Get ScheduledList value
     * @return \ebay\StructType\ItemListCustomizationType|null
     */
    public function getScheduledList()
    {
        return $this->ScheduledList;
    }
    /**
     * Set ScheduledList value
     * @param \ebay\StructType\ItemListCustomizationType $scheduledList
     * @return \ebay\StructType\GetMyeBaySellingRequestType
     */
    public function setScheduledList(\ebay\StructType\ItemListCustomizationType $scheduledList = null)
    {
        $this->ScheduledList = $scheduledList;
        return $this;
    }
    /**
     * Get ActiveList value
     * @return \ebay\StructType\ItemListCustomizationType|null
     */
    public function getActiveList()
    {
        return $this->ActiveList;
    }
    /**
     * Set ActiveList value
     * @param \ebay\StructType\ItemListCustomizationType $activeList
     * @return \ebay\StructType\GetMyeBaySellingRequestType
     */
    public function setActiveList(\ebay\StructType\ItemListCustomizationType $activeList = null)
    {
        $this->ActiveList = $activeList;
        return $this;
    }
    /**
     * Get SoldList value
     * @return \ebay\StructType\ItemListCustomizationType|null
     */
    public function getSoldList()
    {
        return $this->SoldList;
    }
    /**
     * Set SoldList value
     * @param \ebay\StructType\ItemListCustomizationType $soldList
     * @return \ebay\StructType\GetMyeBaySellingRequestType
     */
    public function setSoldList(\ebay\StructType\ItemListCustomizationType $soldList = null)
    {
        $this->SoldList = $soldList;
        return $this;
    }
    /**
     * Get UnsoldList value
     * @return \ebay\StructType\ItemListCustomizationType|null
     */
    public function getUnsoldList()
    {
        return $this->UnsoldList;
    }
    /**
     * Set UnsoldList value
     * @param \ebay\StructType\ItemListCustomizationType $unsoldList
     * @return \ebay\StructType\GetMyeBaySellingRequestType
     */
    public function setUnsoldList(\ebay\StructType\ItemListCustomizationType $unsoldList = null)
    {
        $this->UnsoldList = $unsoldList;
        return $this;
    }
    /**
     * Get BidList value
     * @return \ebay\StructType\ItemListCustomizationType|null
     */
    public function getBidList()
    {
        return $this->BidList;
    }
    /**
     * Set BidList value
     * @param \ebay\StructType\ItemListCustomizationType $bidList
     * @return \ebay\StructType\GetMyeBaySellingRequestType
     */
    public function setBidList(\ebay\StructType\ItemListCustomizationType $bidList = null)
    {
        $this->BidList = $bidList;
        return $this;
    }
    /**
     * Get DeletedFromSoldList value
     * @return \ebay\StructType\ItemListCustomizationType|null
     */
    public function getDeletedFromSoldList()
    {
        return $this->DeletedFromSoldList;
    }
    /**
     * Set DeletedFromSoldList value
     * @param \ebay\StructType\ItemListCustomizationType $deletedFromSoldList
     * @return \ebay\StructType\GetMyeBaySellingRequestType
     */
    public function setDeletedFromSoldList(\ebay\StructType\ItemListCustomizationType $deletedFromSoldList = null)
    {
        $this->DeletedFromSoldList = $deletedFromSoldList;
        return $this;
    }
    /**
     * Get DeletedFromUnsoldList value
     * @return \ebay\StructType\ItemListCustomizationType|null
     */
    public function getDeletedFromUnsoldList()
    {
        return $this->DeletedFromUnsoldList;
    }
    /**
     * Set DeletedFromUnsoldList value
     * @param \ebay\StructType\ItemListCustomizationType $deletedFromUnsoldList
     * @return \ebay\StructType\GetMyeBaySellingRequestType
     */
    public function setDeletedFromUnsoldList(\ebay\StructType\ItemListCustomizationType $deletedFromUnsoldList = null)
    {
        $this->DeletedFromUnsoldList = $deletedFromUnsoldList;
        return $this;
    }
    /**
     * Get SellingSummary value
     * @return \ebay\StructType\ItemListCustomizationType|null
     */
    public function getSellingSummary()
    {
        return $this->SellingSummary;
    }
    /**
     * Set SellingSummary value
     * @param \ebay\StructType\ItemListCustomizationType $sellingSummary
     * @return \ebay\StructType\GetMyeBaySellingRequestType
     */
    public function setSellingSummary(\ebay\StructType\ItemListCustomizationType $sellingSummary = null)
    {
        $this->SellingSummary = $sellingSummary;
        return $this;
    }
    /**
     * Get HideVariations value
     * @return bool|null
     */
    public function getHideVariations()
    {
        return $this->HideVariations;
    }
    /**
     * Set HideVariations value
     * @param bool $hideVariations
     * @return \ebay\StructType\GetMyeBaySellingRequestType
     */
    public function setHideVariations($hideVariations = null)
    {
        $this->HideVariations = $hideVariations;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \ebay\StructType\GetMyeBaySellingRequestType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
