<?php

namespace ebay\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetCategorySpecificsResponseType StructType
 * Meta informations extracted from the WSDL
 * - documentation: This is the base response type for the <b>GetCategorySpecifics</b> call. This call retrieves recommended Item Specifics names and values for one or multiple eBay Categories.
 * @subpackage Structs
 * @date 2017-04-07 16
 */
class GetCategorySpecificsResponseType extends AbstractResponseType
{
    /**
     * The Recommendations
     * Meta informations extracted from the WSDL
     * - documentation: This container provide details about recommended Item Specifics and Product Identifier types. Contains the most popular Item Specifics and supported/required Product Identifier types, if any, for a category specified in the request,
     * or contains information about whether the recommendations have changed for that category since the LastUpdateTime you requested. <br> <br> The most relevant Item Specifics are returned first. If a name has multiple values, the first value is more
     * popular.<br> <br> This node returns empty (or it's not returned) for a category if there is no applicable data (such as when you request a parent category, a category that has no popular Item Specifics yet, or a duplicate category that was already
     * returned). If you pass in the CategoryID and Name fields together, but no matching values are found for the name, eBay returns the name with no values (even if the name is not recommended).<br> <br> If GetCategoryFeatures indicates that custom Item
     * Specifics are enabled for a leaf category, but GetCategorySpecifics doesn't return any recommendations for that category, the seller can still specify their own custom Item Specifics in that category.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \ebay\StructType\RecommendationsType[]
     */
    public $Recommendations;
    /**
     * The TaskReferenceID
     * Meta informations extracted from the WSDL
     * - documentation: A <b>TaskReferenceID</b> and a <b>FileReferenceID</b> value are returned if the <b>CategorySpecificsFileInfo</b> field is included in the call request and set to <code>true</code>. These values will be used as inputs in the
     * <b>downloadFile</b> call of the File Transfer API. That API lets you retrieve a single (bulk) <b>GetCategorySpecifics</b> response with all the Item Specifics recommendations available for the requested site ID. (The <b>downloadFile</b> call
     * downloads a .zip file as an attachment.)
     * - minOccurs: 0
     * @var string
     */
    public $TaskReferenceID;
    /**
     * The FileReferenceID
     * Meta informations extracted from the WSDL
     * - documentation: A <b>TaskReferenceID</b> and a <b>FileReferenceID</b> value are returned if the <b>CategorySpecificsFileInfo</b> field is included in the call request and set to <code>true</code>. These values will be used as inputs in the
     * <b>downloadFile</b> call of the File Transfer API. That API lets you retrieve a single (bulk) <b>GetCategorySpecifics</b> response with all the Item Specifics recommendations available for the requested site ID. (The <b>downloadFile</b> call
     * downloads a .zip file as an attachment.)
     * - minOccurs: 0
     * @var string
     */
    public $FileReferenceID;
    /**
     * Constructor method for GetCategorySpecificsResponseType
     * @uses GetCategorySpecificsResponseType::setRecommendations()
     * @uses GetCategorySpecificsResponseType::setTaskReferenceID()
     * @uses GetCategorySpecificsResponseType::setFileReferenceID()
     * @param \ebay\StructType\RecommendationsType[] $recommendations
     * @param string $taskReferenceID
     * @param string $fileReferenceID
     */
    public function __construct(array $recommendations = array(), $taskReferenceID = null, $fileReferenceID = null)
    {
        $this
            ->setRecommendations($recommendations)
            ->setTaskReferenceID($taskReferenceID)
            ->setFileReferenceID($fileReferenceID);
    }
    /**
     * Get Recommendations value
     * @return \ebay\StructType\RecommendationsType[]|null
     */
    public function getRecommendations()
    {
        return $this->Recommendations;
    }
    /**
     * Set Recommendations value
     * @throws \InvalidArgumentException
     * @param \ebay\StructType\RecommendationsType[] $recommendations
     * @return \ebay\StructType\GetCategorySpecificsResponseType
     */
    public function setRecommendations(array $recommendations = array())
    {
        foreach ($recommendations as $getCategorySpecificsResponseTypeRecommendationsItem) {
            // validation for constraint: itemType
            if (!$getCategorySpecificsResponseTypeRecommendationsItem instanceof \ebay\StructType\RecommendationsType) {
                throw new \InvalidArgumentException(sprintf('The Recommendations property can only contain items of \ebay\StructType\RecommendationsType, "%s" given', is_object($getCategorySpecificsResponseTypeRecommendationsItem) ? get_class($getCategorySpecificsResponseTypeRecommendationsItem) : gettype($getCategorySpecificsResponseTypeRecommendationsItem)), __LINE__);
            }
        }
        $this->Recommendations = $recommendations;
        return $this;
    }
    /**
     * Add item to Recommendations value
     * @throws \InvalidArgumentException
     * @param \ebay\StructType\RecommendationsType $item
     * @return \ebay\StructType\GetCategorySpecificsResponseType
     */
    public function addToRecommendations(\ebay\StructType\RecommendationsType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \ebay\StructType\RecommendationsType) {
            throw new \InvalidArgumentException(sprintf('The Recommendations property can only contain items of \ebay\StructType\RecommendationsType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Recommendations[] = $item;
        return $this;
    }
    /**
     * Get TaskReferenceID value
     * @return string|null
     */
    public function getTaskReferenceID()
    {
        return $this->TaskReferenceID;
    }
    /**
     * Set TaskReferenceID value
     * @param string $taskReferenceID
     * @return \ebay\StructType\GetCategorySpecificsResponseType
     */
    public function setTaskReferenceID($taskReferenceID = null)
    {
        // validation for constraint: string
        if (!is_null($taskReferenceID) && !is_string($taskReferenceID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($taskReferenceID)), __LINE__);
        }
        $this->TaskReferenceID = $taskReferenceID;
        return $this;
    }
    /**
     * Get FileReferenceID value
     * @return string|null
     */
    public function getFileReferenceID()
    {
        return $this->FileReferenceID;
    }
    /**
     * Set FileReferenceID value
     * @param string $fileReferenceID
     * @return \ebay\StructType\GetCategorySpecificsResponseType
     */
    public function setFileReferenceID($fileReferenceID = null)
    {
        // validation for constraint: string
        if (!is_null($fileReferenceID) && !is_string($fileReferenceID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fileReferenceID)), __LINE__);
        }
        $this->FileReferenceID = $fileReferenceID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \ebay\StructType\GetCategorySpecificsResponseType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
