<?php

namespace ebay\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EndItemResponseType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Includes the acknowledgement of date and time the auction was ended due to the call to EndItem.
 * @subpackage Structs
 * @date 2017-04-07 16
 */
class EndItemResponseType extends AbstractResponseType
{
    /**
     * The EndTime
     * Meta informations extracted from the WSDL
     * - documentation: Indicates the date and time (returned in GMT) the specified item listing was ended. Also applicable to Half.com.
     * - minOccurs: 0
     * @var string
     */
    public $EndTime;
    /**
     * Constructor method for EndItemResponseType
     * @uses EndItemResponseType::setEndTime()
     * @param string $endTime
     */
    public function __construct($endTime = null)
    {
        $this
            ->setEndTime($endTime);
    }
    /**
     * Get EndTime value
     * @return string|null
     */
    public function getEndTime()
    {
        return $this->EndTime;
    }
    /**
     * Set EndTime value
     * @param string $endTime
     * @return \ebay\StructType\EndItemResponseType
     */
    public function setEndTime($endTime = null)
    {
        // validation for constraint: string
        if (!is_null($endTime) && !is_string($endTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($endTime)), __LINE__);
        }
        $this->EndTime = $endTime;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \ebay\StructType\EndItemResponseType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
