<?php

namespace ebay\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Verify ServiceType
 * @subpackage Services
 * @date 2017-04-07 16
 */
class Verify extends AbstractSoapClientBase
{
    /**
     * Sets the RequesterCredentials SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \ebay\StructType\CustomSecurityHeaderType $requesterCredentials
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderRequesterCredentials(\ebay\StructType\CustomSecurityHeaderType $requesterCredentials, $nameSpace = 'urn:ebay:apis:eBLBaseComponents', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'RequesterCredentials', $requesterCredentials, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named VerifyAddFixedPriceItem
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames : RequesterCredentials
     * - SOAPHeaderNamespaces : urn:ebay:apis:eBLBaseComponents
     * - SOAPHeaderTypes : \ebay\StructType\CustomSecurityHeaderType
     * - SOAPHeaders : required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \ebay\StructType\VerifyAddFixedPriceItemRequestType $verifyAddFixedPriceItemRequest
     * @return \ebay\StructType\VerifyAddFixedPriceItemResponseType|bool
     */
    public function VerifyAddFixedPriceItem(\ebay\StructType\VerifyAddFixedPriceItemRequestType $verifyAddFixedPriceItemRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->VerifyAddFixedPriceItem($verifyAddFixedPriceItemRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named VerifyAddItem
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames : RequesterCredentials
     * - SOAPHeaderNamespaces : urn:ebay:apis:eBLBaseComponents
     * - SOAPHeaderTypes : \ebay\StructType\CustomSecurityHeaderType
     * - SOAPHeaders : required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \ebay\StructType\VerifyAddItemRequestType $verifyAddItemRequest
     * @return \ebay\StructType\VerifyAddItemResponseType|bool
     */
    public function VerifyAddItem(\ebay\StructType\VerifyAddItemRequestType $verifyAddItemRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->VerifyAddItem($verifyAddItemRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named VerifyAddSecondChanceItem
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames : RequesterCredentials
     * - SOAPHeaderNamespaces : urn:ebay:apis:eBLBaseComponents
     * - SOAPHeaderTypes : \ebay\StructType\CustomSecurityHeaderType
     * - SOAPHeaders : required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \ebay\StructType\VerifyAddSecondChanceItemRequestType $verifyAddSecondChanceItemRequest
     * @return \ebay\StructType\VerifyAddSecondChanceItemResponseType|bool
     */
    public function VerifyAddSecondChanceItem(\ebay\StructType\VerifyAddSecondChanceItemRequestType $verifyAddSecondChanceItemRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->VerifyAddSecondChanceItem($verifyAddSecondChanceItemRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named VerifyRelistItem
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames : RequesterCredentials
     * - SOAPHeaderNamespaces : urn:ebay:apis:eBLBaseComponents
     * - SOAPHeaderTypes : \ebay\StructType\CustomSecurityHeaderType
     * - SOAPHeaders : required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \ebay\StructType\VerifyRelistItemRequestType $verifyRelistItemRequest
     * @return \ebay\StructType\VerifyRelistItemResponseType|bool
     */
    public function VerifyRelistItem(\ebay\StructType\VerifyRelistItemRequestType $verifyRelistItemRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->VerifyRelistItem($verifyRelistItemRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \ebay\StructType\VerifyAddFixedPriceItemResponseType|\ebay\StructType\VerifyAddItemResponseType|\ebay\StructType\VerifyAddSecondChanceItemResponseType|\ebay\StructType\VerifyRelistItemResponseType
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
