<?php

namespace ebay\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for End ServiceType
 * @subpackage Services
 * @date 2017-04-07 16
 */
class End extends AbstractSoapClientBase
{
    /**
     * Sets the RequesterCredentials SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \ebay\StructType\CustomSecurityHeaderType $requesterCredentials
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderRequesterCredentials(\ebay\StructType\CustomSecurityHeaderType $requesterCredentials, $nameSpace = 'urn:ebay:apis:eBLBaseComponents', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'RequesterCredentials', $requesterCredentials, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named EndFixedPriceItem
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames : RequesterCredentials
     * - SOAPHeaderNamespaces : urn:ebay:apis:eBLBaseComponents
     * - SOAPHeaderTypes : \ebay\StructType\CustomSecurityHeaderType
     * - SOAPHeaders : required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \ebay\StructType\EndFixedPriceItemRequestType $endFixedPriceItemRequest
     * @return \ebay\StructType\EndFixedPriceItemResponseType|bool
     */
    public function EndFixedPriceItem(\ebay\StructType\EndFixedPriceItemRequestType $endFixedPriceItemRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->EndFixedPriceItem($endFixedPriceItemRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EndItem
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames : RequesterCredentials
     * - SOAPHeaderNamespaces : urn:ebay:apis:eBLBaseComponents
     * - SOAPHeaderTypes : \ebay\StructType\CustomSecurityHeaderType
     * - SOAPHeaders : required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \ebay\StructType\EndItemRequestType $endItemRequest
     * @return \ebay\StructType\EndItemResponseType|bool
     */
    public function EndItem(\ebay\StructType\EndItemRequestType $endItemRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->EndItem($endItemRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EndItems
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames : RequesterCredentials
     * - SOAPHeaderNamespaces : urn:ebay:apis:eBLBaseComponents
     * - SOAPHeaderTypes : \ebay\StructType\CustomSecurityHeaderType
     * - SOAPHeaders : required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \ebay\StructType\EndItemsRequestType $endItemsRequest
     * @return \ebay\StructType\EndItemsResponseType|bool
     */
    public function EndItems(\ebay\StructType\EndItemsRequestType $endItemsRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->EndItems($endItemsRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \ebay\StructType\EndFixedPriceItemResponseType|\ebay\StructType\EndItemResponseType|\ebay\StructType\EndItemsResponseType
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
