<?php

namespace ebay\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Add ServiceType
 * @subpackage Services
 * @date 2017-04-07 16
 */
class Add extends AbstractSoapClientBase
{
    /**
     * Sets the RequesterCredentials SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \ebay\StructType\CustomSecurityHeaderType $requesterCredentials
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderRequesterCredentials(\ebay\StructType\CustomSecurityHeaderType $requesterCredentials, $nameSpace = 'urn:ebay:apis:eBLBaseComponents', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'RequesterCredentials', $requesterCredentials, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named AddDispute
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames : RequesterCredentials
     * - SOAPHeaderNamespaces : urn:ebay:apis:eBLBaseComponents
     * - SOAPHeaderTypes : \ebay\StructType\CustomSecurityHeaderType
     * - SOAPHeaders : required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \ebay\StructType\AddDisputeRequestType $addDisputeRequest
     * @return \ebay\StructType\AddDisputeResponseType|bool
     */
    public function AddDispute(\ebay\StructType\AddDisputeRequestType $addDisputeRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->AddDispute($addDisputeRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddDisputeResponse
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames : RequesterCredentials
     * - SOAPHeaderNamespaces : urn:ebay:apis:eBLBaseComponents
     * - SOAPHeaderTypes : \ebay\StructType\CustomSecurityHeaderType
     * - SOAPHeaders : required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \ebay\StructType\AddDisputeResponseRequestType $addDisputeResponseRequest
     * @return \ebay\StructType\AddDisputeResponseResponseType|bool
     */
    public function AddDisputeResponse(\ebay\StructType\AddDisputeResponseRequestType $addDisputeResponseRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->AddDisputeResponse($addDisputeResponseRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddFixedPriceItem
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames : RequesterCredentials
     * - SOAPHeaderNamespaces : urn:ebay:apis:eBLBaseComponents
     * - SOAPHeaderTypes : \ebay\StructType\CustomSecurityHeaderType
     * - SOAPHeaders : required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \ebay\StructType\AddFixedPriceItemRequestType $addFixedPriceItemRequest
     * @return \ebay\StructType\AddFixedPriceItemResponseType|bool
     */
    public function AddFixedPriceItem(\ebay\StructType\AddFixedPriceItemRequestType $addFixedPriceItemRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->AddFixedPriceItem($addFixedPriceItemRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddItem
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames : RequesterCredentials
     * - SOAPHeaderNamespaces : urn:ebay:apis:eBLBaseComponents
     * - SOAPHeaderTypes : \ebay\StructType\CustomSecurityHeaderType
     * - SOAPHeaders : required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \ebay\StructType\AddItemRequestType $addItemRequest
     * @return \ebay\StructType\AddItemResponseType|bool
     */
    public function AddItem(\ebay\StructType\AddItemRequestType $addItemRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->AddItem($addItemRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddItemFromSellingManagerTemplate
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames : RequesterCredentials
     * - SOAPHeaderNamespaces : urn:ebay:apis:eBLBaseComponents
     * - SOAPHeaderTypes : \ebay\StructType\CustomSecurityHeaderType
     * - SOAPHeaders : required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \ebay\StructType\AddItemFromSellingManagerTemplateRequestType $addItemFromSellingManagerTemplateRequest
     * @return \ebay\StructType\AddItemFromSellingManagerTemplateResponseType|bool
     */
    public function AddItemFromSellingManagerTemplate(\ebay\StructType\AddItemFromSellingManagerTemplateRequestType $addItemFromSellingManagerTemplateRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->AddItemFromSellingManagerTemplate($addItemFromSellingManagerTemplateRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddItems
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames : RequesterCredentials
     * - SOAPHeaderNamespaces : urn:ebay:apis:eBLBaseComponents
     * - SOAPHeaderTypes : \ebay\StructType\CustomSecurityHeaderType
     * - SOAPHeaders : required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \ebay\StructType\AddItemsRequestType $addItemsRequest
     * @return \ebay\StructType\AddItemsResponseType|bool
     */
    public function AddItems(\ebay\StructType\AddItemsRequestType $addItemsRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->AddItems($addItemsRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddMemberMessageAAQToPartner
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames : RequesterCredentials
     * - SOAPHeaderNamespaces : urn:ebay:apis:eBLBaseComponents
     * - SOAPHeaderTypes : \ebay\StructType\CustomSecurityHeaderType
     * - SOAPHeaders : required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \ebay\StructType\AddMemberMessageAAQToPartnerRequestType $addMemberMessageAAQToPartnerRequest
     * @return \ebay\StructType\AddMemberMessageAAQToPartnerResponseType|bool
     */
    public function AddMemberMessageAAQToPartner(\ebay\StructType\AddMemberMessageAAQToPartnerRequestType $addMemberMessageAAQToPartnerRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->AddMemberMessageAAQToPartner($addMemberMessageAAQToPartnerRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddMemberMessageRTQ
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames : RequesterCredentials
     * - SOAPHeaderNamespaces : urn:ebay:apis:eBLBaseComponents
     * - SOAPHeaderTypes : \ebay\StructType\CustomSecurityHeaderType
     * - SOAPHeaders : required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \ebay\StructType\AddMemberMessageRTQRequestType $addMemberMessageRTQRequest
     * @return \ebay\StructType\AddMemberMessageRTQResponseType|bool
     */
    public function AddMemberMessageRTQ(\ebay\StructType\AddMemberMessageRTQRequestType $addMemberMessageRTQRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->AddMemberMessageRTQ($addMemberMessageRTQRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddMemberMessagesAAQToBidder
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames : RequesterCredentials
     * - SOAPHeaderNamespaces : urn:ebay:apis:eBLBaseComponents
     * - SOAPHeaderTypes : \ebay\StructType\CustomSecurityHeaderType
     * - SOAPHeaders : required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \ebay\StructType\AddMemberMessagesAAQToBidderRequestType $addMemberMessagesAAQToBidderRequest
     * @return \ebay\StructType\AddMemberMessagesAAQToBidderResponseType|bool
     */
    public function AddMemberMessagesAAQToBidder(\ebay\StructType\AddMemberMessagesAAQToBidderRequestType $addMemberMessagesAAQToBidderRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->AddMemberMessagesAAQToBidder($addMemberMessagesAAQToBidderRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddOrder
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames : RequesterCredentials
     * - SOAPHeaderNamespaces : urn:ebay:apis:eBLBaseComponents
     * - SOAPHeaderTypes : \ebay\StructType\CustomSecurityHeaderType
     * - SOAPHeaders : required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \ebay\StructType\AddOrderRequestType $addOrderRequest
     * @return \ebay\StructType\AddOrderResponseType|bool
     */
    public function AddOrder(\ebay\StructType\AddOrderRequestType $addOrderRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->AddOrder($addOrderRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddSecondChanceItem
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames : RequesterCredentials
     * - SOAPHeaderNamespaces : urn:ebay:apis:eBLBaseComponents
     * - SOAPHeaderTypes : \ebay\StructType\CustomSecurityHeaderType
     * - SOAPHeaders : required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \ebay\StructType\AddSecondChanceItemRequestType $addSecondChanceItemRequest
     * @return \ebay\StructType\AddSecondChanceItemResponseType|bool
     */
    public function AddSecondChanceItem(\ebay\StructType\AddSecondChanceItemRequestType $addSecondChanceItemRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->AddSecondChanceItem($addSecondChanceItemRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddSellingManagerInventoryFolder
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames : RequesterCredentials
     * - SOAPHeaderNamespaces : urn:ebay:apis:eBLBaseComponents
     * - SOAPHeaderTypes : \ebay\StructType\CustomSecurityHeaderType
     * - SOAPHeaders : required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \ebay\StructType\AddSellingManagerInventoryFolderRequestType $addSellingManagerInventoryFolderRequest
     * @return \ebay\StructType\AddSellingManagerInventoryFolderResponseType|bool
     */
    public function AddSellingManagerInventoryFolder(\ebay\StructType\AddSellingManagerInventoryFolderRequestType $addSellingManagerInventoryFolderRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->AddSellingManagerInventoryFolder($addSellingManagerInventoryFolderRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddSellingManagerProduct
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames : RequesterCredentials
     * - SOAPHeaderNamespaces : urn:ebay:apis:eBLBaseComponents
     * - SOAPHeaderTypes : \ebay\StructType\CustomSecurityHeaderType
     * - SOAPHeaders : required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \ebay\StructType\AddSellingManagerProductRequestType $addSellingManagerProductRequest
     * @return \ebay\StructType\AddSellingManagerProductResponseType|bool
     */
    public function AddSellingManagerProduct(\ebay\StructType\AddSellingManagerProductRequestType $addSellingManagerProductRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->AddSellingManagerProduct($addSellingManagerProductRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddSellingManagerTemplate
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames : RequesterCredentials
     * - SOAPHeaderNamespaces : urn:ebay:apis:eBLBaseComponents
     * - SOAPHeaderTypes : \ebay\StructType\CustomSecurityHeaderType
     * - SOAPHeaders : required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \ebay\StructType\AddSellingManagerTemplateRequestType $addSellingManagerTemplateRequest
     * @return \ebay\StructType\AddSellingManagerTemplateResponseType|bool
     */
    public function AddSellingManagerTemplate(\ebay\StructType\AddSellingManagerTemplateRequestType $addSellingManagerTemplateRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->AddSellingManagerTemplate($addSellingManagerTemplateRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddToItemDescription
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames : RequesterCredentials
     * - SOAPHeaderNamespaces : urn:ebay:apis:eBLBaseComponents
     * - SOAPHeaderTypes : \ebay\StructType\CustomSecurityHeaderType
     * - SOAPHeaders : required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \ebay\StructType\AddToItemDescriptionRequestType $addToItemDescriptionRequest
     * @return \ebay\StructType\AddToItemDescriptionResponseType|bool
     */
    public function AddToItemDescription(\ebay\StructType\AddToItemDescriptionRequestType $addToItemDescriptionRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->AddToItemDescription($addToItemDescriptionRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddToWatchList
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames : RequesterCredentials
     * - SOAPHeaderNamespaces : urn:ebay:apis:eBLBaseComponents
     * - SOAPHeaderTypes : \ebay\StructType\CustomSecurityHeaderType
     * - SOAPHeaders : required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \ebay\StructType\AddToWatchListRequestType $addToWatchListRequest
     * @return \ebay\StructType\AddToWatchListResponseType|bool
     */
    public function AddToWatchList(\ebay\StructType\AddToWatchListRequestType $addToWatchListRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->AddToWatchList($addToWatchListRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddTransactionConfirmationItem
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames : RequesterCredentials
     * - SOAPHeaderNamespaces : urn:ebay:apis:eBLBaseComponents
     * - SOAPHeaderTypes : \ebay\StructType\CustomSecurityHeaderType
     * - SOAPHeaders : required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \ebay\StructType\AddTransactionConfirmationItemRequestType $addTransactionConfirmationItemRequest
     * @return \ebay\StructType\AddTransactionConfirmationItemResponseType|bool
     */
    public function AddTransactionConfirmationItem(\ebay\StructType\AddTransactionConfirmationItemRequestType $addTransactionConfirmationItemRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->AddTransactionConfirmationItem($addTransactionConfirmationItemRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \ebay\StructType\AddDisputeResponseResponseType|\ebay\StructType\AddDisputeResponseType|\ebay\StructType\AddFixedPriceItemResponseType|\ebay\StructType\AddItemFromSellingManagerTemplateResponseType|\ebay\StructType\AddItemResponseType|\ebay\StructType\AddItemsResponseType|\ebay\StructType\AddMemberMessageAAQToPartnerResponseType|\ebay\StructType\AddMemberMessageRTQResponseType|\ebay\StructType\AddMemberMessagesAAQToBidderResponseType|\ebay\StructType\AddOrderResponseType|\ebay\StructType\AddSecondChanceItemResponseType|\ebay\StructType\AddSellingManagerInventoryFolderResponseType|\ebay\StructType\AddSellingManagerProductResponseType|\ebay\StructType\AddSellingManagerTemplateResponseType|\ebay\StructType\AddToItemDescriptionResponseType|\ebay\StructType\AddToWatchListResponseType|\ebay\StructType\AddTransactionConfirmationItemResponseType
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
