<?php

namespace ebay\EnumType;

/**
 * This class stands for UserIdentityCodeType EnumType
 * @subpackage Enumerations
 * @date 2017-04-07 16
 */
class UserIdentityCodeType
{
    /**
     * Constant for value 'eBayUser'
     * @return string 'eBayUser'
     */
    const VALUE_E_BAY_USER = 'eBayUser';
    /**
     * Constant for value 'eBayPartner'
     * @return string 'eBayPartner'
     */
    const VALUE_E_BAY_PARTNER = 'eBayPartner';
    /**
     * Constant for value 'CustomCode'
     * @return string 'CustomCode'
     */
    const VALUE_CUSTOM_CODE = 'CustomCode';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_E_BAY_USER
     * @uses self::VALUE_E_BAY_PARTNER
     * @uses self::VALUE_CUSTOM_CODE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_E_BAY_USER,
            self::VALUE_E_BAY_PARTNER,
            self::VALUE_CUSTOM_CODE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
