<?php

namespace ebay\EnumType;

/**
 * This class stands for MinimumAdvertisedPriceExposureCodeType EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Defines how the buyer is to view the discounted price for MAP items. If a seller offers an item for less than the specified MinimumAdvertisedPrice, the discounted price of the item cannot be displayed on the page containing the item.
 * Use this field to specify how the buyer is to view the discounted item price. This is applicable for MAP items only.
 * @subpackage Enumerations
 * @date 2017-04-07 16
 */
class MinimumAdvertisedPriceExposureCodeType
{
    /**
     * Constant for value 'PreCheckout'
     * @return string 'PreCheckout'
     */
    const VALUE_PRE_CHECKOUT = 'PreCheckout';
    /**
     * Constant for value 'DuringCheckout'
     * @return string 'DuringCheckout'
     */
    const VALUE_DURING_CHECKOUT = 'DuringCheckout';
    /**
     * Constant for value 'None'
     * @return string 'None'
     */
    const VALUE_NONE = 'None';
    /**
     * Constant for value 'CustomCode'
     * @return string 'CustomCode'
     */
    const VALUE_CUSTOM_CODE = 'CustomCode';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_PRE_CHECKOUT
     * @uses self::VALUE_DURING_CHECKOUT
     * @uses self::VALUE_NONE
     * @uses self::VALUE_CUSTOM_CODE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_PRE_CHECKOUT,
            self::VALUE_DURING_CHECKOUT,
            self::VALUE_NONE,
            self::VALUE_CUSTOM_CODE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
