<?php

namespace ebay\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for MyMessagesMessageArrayType ArrayType
 * Meta informations extracted from the WSDL
 * - documentation: Contains a list of message data.
 * @subpackage Arrays
 * @date 2017-04-07 16
 */
class MyMessagesMessageArrayType extends AbstractStructArrayBase
{
    /**
     * The Message
     * Meta informations extracted from the WSDL
     * - documentation: Contains the data for one message.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \ebay\StructType\MyMessagesMessageType[]
     */
    public $Message;
    /**
     * Constructor method for MyMessagesMessageArrayType
     * @uses MyMessagesMessageArrayType::setMessage()
     * @param \ebay\StructType\MyMessagesMessageType[] $message
     */
    public function __construct(array $message = array())
    {
        $this
            ->setMessage($message);
    }
    /**
     * Get Message value
     * @return \ebay\StructType\MyMessagesMessageType[]|null
     */
    public function getMessage()
    {
        return $this->Message;
    }
    /**
     * Set Message value
     * @throws \InvalidArgumentException
     * @param \ebay\StructType\MyMessagesMessageType[] $message
     * @return \ebay\ArrayType\MyMessagesMessageArrayType
     */
    public function setMessage(array $message = array())
    {
        foreach ($message as $myMessagesMessageArrayTypeMessageItem) {
            // validation for constraint: itemType
            if (!$myMessagesMessageArrayTypeMessageItem instanceof \ebay\StructType\MyMessagesMessageType) {
                throw new \InvalidArgumentException(sprintf('The Message property can only contain items of \ebay\StructType\MyMessagesMessageType, "%s" given', is_object($myMessagesMessageArrayTypeMessageItem) ? get_class($myMessagesMessageArrayTypeMessageItem) : gettype($myMessagesMessageArrayTypeMessageItem)), __LINE__);
            }
        }
        $this->Message = $message;
        return $this;
    }
    /**
     * Add item to Message value
     * @throws \InvalidArgumentException
     * @param \ebay\StructType\MyMessagesMessageType $item
     * @return \ebay\ArrayType\MyMessagesMessageArrayType
     */
    public function addToMessage(\ebay\StructType\MyMessagesMessageType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \ebay\StructType\MyMessagesMessageType) {
            throw new \InvalidArgumentException(sprintf('The Message property can only contain items of \ebay\StructType\MyMessagesMessageType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Message[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \ebay\StructType\MyMessagesMessageType|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \ebay\StructType\MyMessagesMessageType|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \ebay\StructType\MyMessagesMessageType|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \ebay\StructType\MyMessagesMessageType|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \ebay\StructType\MyMessagesMessageType|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Message
     */
    public function getAttributeName()
    {
        return 'Message';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ebay\ArrayType\MyMessagesMessageArrayType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
