<?php

namespace ebay\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for MemberMessageExchangeArrayType ArrayType
 * Meta informations extracted from the WSDL
 * - documentation: Container for messages. Returned for GetMemberMessages if messages that meet the request criteria exist.
 * @subpackage Arrays
 * @date 2017-04-07 16
 */
class MemberMessageExchangeArrayType extends AbstractStructArrayBase
{
    /**
     * The MemberMessageExchange
     * Meta informations extracted from the WSDL
     * - documentation: Information about individual messages. Returned if the parent container is returned.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \ebay\StructType\MemberMessageExchangeType[]
     */
    public $MemberMessageExchange;
    /**
     * Constructor method for MemberMessageExchangeArrayType
     * @uses MemberMessageExchangeArrayType::setMemberMessageExchange()
     * @param \ebay\StructType\MemberMessageExchangeType[] $memberMessageExchange
     */
    public function __construct(array $memberMessageExchange = array())
    {
        $this
            ->setMemberMessageExchange($memberMessageExchange);
    }
    /**
     * Get MemberMessageExchange value
     * @return \ebay\StructType\MemberMessageExchangeType[]|null
     */
    public function getMemberMessageExchange()
    {
        return $this->MemberMessageExchange;
    }
    /**
     * Set MemberMessageExchange value
     * @throws \InvalidArgumentException
     * @param \ebay\StructType\MemberMessageExchangeType[] $memberMessageExchange
     * @return \ebay\ArrayType\MemberMessageExchangeArrayType
     */
    public function setMemberMessageExchange(array $memberMessageExchange = array())
    {
        foreach ($memberMessageExchange as $memberMessageExchangeArrayTypeMemberMessageExchangeItem) {
            // validation for constraint: itemType
            if (!$memberMessageExchangeArrayTypeMemberMessageExchangeItem instanceof \ebay\StructType\MemberMessageExchangeType) {
                throw new \InvalidArgumentException(sprintf('The MemberMessageExchange property can only contain items of \ebay\StructType\MemberMessageExchangeType, "%s" given', is_object($memberMessageExchangeArrayTypeMemberMessageExchangeItem) ? get_class($memberMessageExchangeArrayTypeMemberMessageExchangeItem) : gettype($memberMessageExchangeArrayTypeMemberMessageExchangeItem)), __LINE__);
            }
        }
        $this->MemberMessageExchange = $memberMessageExchange;
        return $this;
    }
    /**
     * Add item to MemberMessageExchange value
     * @throws \InvalidArgumentException
     * @param \ebay\StructType\MemberMessageExchangeType $item
     * @return \ebay\ArrayType\MemberMessageExchangeArrayType
     */
    public function addToMemberMessageExchange(\ebay\StructType\MemberMessageExchangeType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \ebay\StructType\MemberMessageExchangeType) {
            throw new \InvalidArgumentException(sprintf('The MemberMessageExchange property can only contain items of \ebay\StructType\MemberMessageExchangeType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->MemberMessageExchange[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \ebay\StructType\MemberMessageExchangeType|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \ebay\StructType\MemberMessageExchangeType|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \ebay\StructType\MemberMessageExchangeType|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \ebay\StructType\MemberMessageExchangeType|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \ebay\StructType\MemberMessageExchangeType|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string MemberMessageExchange
     */
    public function getAttributeName()
    {
        return 'MemberMessageExchange';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ebay\ArrayType\MemberMessageExchangeArrayType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
