<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://staging.flightmyweb.com/Air/AirTicketBookingService.asmx?wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://staging.flightmyweb.com/Air/AirTicketBookingService.asmx?wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Get ServiceType
 */
$get = new \ServiceType\Get($options);
$get->setSoapHeaderAuthenticate(new \StructType\Authenticate());
/**
 * Sample call for GetFlightAvailibility operation/method
 */
if ($get->GetFlightAvailibility(new \StructType\GetFlightAvailibility()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetFareRule operation/method
 */
if ($get->GetFareRule(new \StructType\GetFareRule()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetAirportCodes operation/method
 */
if ($get->GetAirportCodes(new \StructType\GetAirportCodes()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetCountryCodes operation/method
 */
if ($get->GetCountryCodes(new \StructType\GetCountryCodes()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetAdditionalServices operation/method
 */
if ($get->GetAdditionalServices(new \StructType\GetAdditionalServices()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetBalance operation/method
 */
if ($get->GetBalance(new \StructType\GetBalance()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Verify ServiceType
 */
$verify = new \ServiceType\Verify($options);
$verify->setSoapHeaderAuthenticate(new \StructType\Authenticate());
/**
 * Sample call for VerifyFlightDetail operation/method
 */
if ($verify->VerifyFlightDetail(new \StructType\VerifyFlightDetail()) !== false) {
    print_r($verify->getResult());
} else {
    print_r($verify->getLastError());
}
/**
 * Samples for Book ServiceType
 */
$book = new \ServiceType\Book($options);
$book->setSoapHeaderAuthenticate(new \StructType\Authenticate());
/**
 * Sample call for BookTicket operation/method
 */
if ($book->BookTicket(new \StructType\BookTicket()) !== false) {
    print_r($book->getResult());
} else {
    print_r($book->getLastError());
}
/**
 * Sample call for BookTicketConfirm operation/method
 */
if ($book->BookTicketConfirm(new \StructType\BookTicketConfirm()) !== false) {
    print_r($book->getResult());
} else {
    print_r($book->getLastError());
}
/**
 * Samples for PNRD ServiceType
 */
$pNRD = new \ServiceType\PNRD($options);
$pNRD->setSoapHeaderAuthenticate(new \StructType\Authenticate());
/**
 * Sample call for PNRDetails operation/method
 */
if ($pNRD->PNRDetails(new \StructType\PNRDetails()) !== false) {
    print_r($pNRD->getResult());
} else {
    print_r($pNRD->getLastError());
}
/**
 * Samples for Ticket ServiceType
 */
$ticket = new \ServiceType\Ticket($options);
$ticket->setSoapHeaderAuthenticate(new \StructType\Authenticate());
/**
 * Sample call for TicketCancel operation/method
 */
if ($ticket->TicketCancel(new \StructType\TicketCancel()) !== false) {
    print_r($ticket->getResult());
} else {
    print_r($ticket->getLastError());
}
/**
 * Sample call for TicketReschedule operation/method
 */
if ($ticket->TicketReschedule(new \StructType\TicketReschedule()) !== false) {
    print_r($ticket->getResult());
} else {
    print_r($ticket->getLastError());
}
/**
 * Samples for Cancel ServiceType
 */
$cancel = new \ServiceType\Cancel($options);
$cancel->setSoapHeaderAuthenticate(new \StructType\Authenticate());
/**
 * Sample call for CancelTicketHistory operation/method
 */
if ($cancel->CancelTicketHistory(new \StructType\CancelTicketHistory()) !== false) {
    print_r($cancel->getResult());
} else {
    print_r($cancel->getLastError());
}
/**
 * Samples for Reissue ServiceType
 */
$reissue = new \ServiceType\Reissue($options);
$reissue->setSoapHeaderAuthenticate(new \StructType\Authenticate());
/**
 * Sample call for Reissue_BookFlight operation/method
 */
if ($reissue->Reissue_BookFlight(new \StructType\Reissue_BookFlight()) !== false) {
    print_r($reissue->getResult());
} else {
    print_r($reissue->getLastError());
}
/**
 * Sample call for Reissue_GetFlight operation/method
 */
if ($reissue->Reissue_GetFlight(new \StructType\Reissue_GetFlight()) !== false) {
    print_r($reissue->getResult());
} else {
    print_r($reissue->getLastError());
}
