<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Reissue ServiceType
 * @subpackage Services
 */
class Reissue extends AbstractSoapClientBase
{
    /**
     * Sets the Authenticate SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\Authenticate $authenticate
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderAuthenticate(\StructType\Authenticate $authenticate, $nameSpace = 'http://tempuri.org/', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'Authenticate', $authenticate, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named Reissue_BookFlight
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Authenticate
     * - SOAPHeaderNamespaces: http://tempuri.org/
     * - SOAPHeaderTypes: \StructType\Authenticate
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Reissue_BookFlight $parameters
     * @return \StructType\Reissue_BookFlightResponse|bool
     */
    public function Reissue_BookFlight(\StructType\Reissue_BookFlight $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->Reissue_BookFlight($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Reissue_GetFlight
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Authenticate
     * - SOAPHeaderNamespaces: http://tempuri.org/
     * - SOAPHeaderTypes: \StructType\Authenticate
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Reissue_GetFlight $parameters
     * @return \StructType\Reissue_GetFlightResponse|bool
     */
    public function Reissue_GetFlight(\StructType\Reissue_GetFlight $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->Reissue_GetFlight($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\Reissue_BookFlightResponse|\StructType\Reissue_GetFlightResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
