<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Sets the Authenticate SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\Authenticate $authenticate
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderAuthenticate(\StructType\Authenticate $authenticate, $nameSpace = 'http://tempuri.org/', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'Authenticate', $authenticate, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named GetFlightAvailibility
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Authenticate
     * - SOAPHeaderNamespaces: http://tempuri.org/
     * - SOAPHeaderTypes: \StructType\Authenticate
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetFlightAvailibility $parameters
     * @return \StructType\GetFlightAvailibilityResponse|bool
     */
    public function GetFlightAvailibility(\StructType\GetFlightAvailibility $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetFlightAvailibility($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetFareRule
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Authenticate
     * - SOAPHeaderNamespaces: http://tempuri.org/
     * - SOAPHeaderTypes: \StructType\Authenticate
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetFareRule $parameters
     * @return \StructType\GetFareRuleResponse|bool
     */
    public function GetFareRule(\StructType\GetFareRule $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetFareRule($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAirportCodes
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Authenticate
     * - SOAPHeaderNamespaces: http://tempuri.org/
     * - SOAPHeaderTypes: \StructType\Authenticate
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAirportCodes $parameters
     * @return \StructType\GetAirportCodesResponse|bool
     */
    public function GetAirportCodes(\StructType\GetAirportCodes $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetAirportCodes($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCountryCodes
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Authenticate
     * - SOAPHeaderNamespaces: http://tempuri.org/
     * - SOAPHeaderTypes: \StructType\Authenticate
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCountryCodes $parameters
     * @return \StructType\GetCountryCodesResponse|bool
     */
    public function GetCountryCodes(\StructType\GetCountryCodes $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetCountryCodes($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAdditionalServices
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Authenticate
     * - SOAPHeaderNamespaces: http://tempuri.org/
     * - SOAPHeaderTypes: \StructType\Authenticate
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAdditionalServices $parameters
     * @return \StructType\GetAdditionalServicesResponse|bool
     */
    public function GetAdditionalServices(\StructType\GetAdditionalServices $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetAdditionalServices($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetBalance
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Authenticate
     * - SOAPHeaderNamespaces: http://tempuri.org/
     * - SOAPHeaderTypes: \StructType\Authenticate
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetBalance $parameters
     * @return \StructType\GetBalanceResponse|bool
     */
    public function GetBalance(\StructType\GetBalance $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetBalance($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GetAdditionalServicesResponse|\StructType\GetAirportCodesResponse|\StructType\GetBalanceResponse|\StructType\GetCountryCodesResponse|\StructType\GetFareRuleResponse|\StructType\GetFlightAvailibilityResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
