<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Authenticate StructType
 * Meta informations extracted from the WSDL
 * - type: tns:Authenticate
 * @subpackage Structs
 */
class Authenticate extends AbstractStructBase
{
    /**
     * The InterfaceCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $InterfaceCode;
    /**
     * The InterfaceAuthKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $InterfaceAuthKey;
    /**
     * The AgentCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AgentCode;
    /**
     * The Password
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Password;
    /**
     * Constructor method for Authenticate
     * @uses Authenticate::setInterfaceCode()
     * @uses Authenticate::setInterfaceAuthKey()
     * @uses Authenticate::setAgentCode()
     * @uses Authenticate::setPassword()
     * @param int $interfaceCode
     * @param string $interfaceAuthKey
     * @param string $agentCode
     * @param string $password
     */
    public function __construct($interfaceCode = null, $interfaceAuthKey = null, $agentCode = null, $password = null)
    {
        $this
            ->setInterfaceCode($interfaceCode)
            ->setInterfaceAuthKey($interfaceAuthKey)
            ->setAgentCode($agentCode)
            ->setPassword($password);
    }
    /**
     * Get InterfaceCode value
     * @return int
     */
    public function getInterfaceCode()
    {
        return $this->InterfaceCode;
    }
    /**
     * Set InterfaceCode value
     * @param int $interfaceCode
     * @return \StructType\Authenticate
     */
    public function setInterfaceCode($interfaceCode = null)
    {
        // validation for constraint: int
        if (!is_null($interfaceCode) && !is_numeric($interfaceCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($interfaceCode)), __LINE__);
        }
        $this->InterfaceCode = $interfaceCode;
        return $this;
    }
    /**
     * Get InterfaceAuthKey value
     * @return string|null
     */
    public function getInterfaceAuthKey()
    {
        return $this->InterfaceAuthKey;
    }
    /**
     * Set InterfaceAuthKey value
     * @param string $interfaceAuthKey
     * @return \StructType\Authenticate
     */
    public function setInterfaceAuthKey($interfaceAuthKey = null)
    {
        // validation for constraint: string
        if (!is_null($interfaceAuthKey) && !is_string($interfaceAuthKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($interfaceAuthKey)), __LINE__);
        }
        $this->InterfaceAuthKey = $interfaceAuthKey;
        return $this;
    }
    /**
     * Get AgentCode value
     * @return string|null
     */
    public function getAgentCode()
    {
        return $this->AgentCode;
    }
    /**
     * Set AgentCode value
     * @param string $agentCode
     * @return \StructType\Authenticate
     */
    public function setAgentCode($agentCode = null)
    {
        // validation for constraint: string
        if (!is_null($agentCode) && !is_string($agentCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($agentCode)), __LINE__);
        }
        $this->AgentCode = $agentCode;
        return $this;
    }
    /**
     * Get Password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->Password;
    }
    /**
     * Set Password value
     * @param string $password
     * @return \StructType\Authenticate
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password)), __LINE__);
        }
        $this->Password = $password;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Authenticate
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
