<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for PNRD ServiceType
 * @subpackage Services
 */
class PNRD extends AbstractSoapClientBase
{
    /**
     * Sets the Authenticate SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\Authenticate $authenticate
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderAuthenticate(\StructType\Authenticate $authenticate, $nameSpace = 'http://tempuri.org/', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'Authenticate', $authenticate, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named PNRDetails
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Authenticate
     * - SOAPHeaderNamespaces: http://tempuri.org/
     * - SOAPHeaderTypes: \StructType\Authenticate
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PNRDetails $parameters
     * @return \StructType\PNRDetailsResponse|bool
     */
    public function PNRDetails(\StructType\PNRDetails $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->PNRDetails($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\PNRDetailsResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
