<?php

namespace mriNaturalProd\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GetNaturalProdList
     * Meta informations extracted from the WSDL
     * - documentation: Welcome to the Natural Health Products information database, powered by MediResource™. This is your source for information on a wide range of natural health products. | Welcome to the Natural Health Products information database,
     * powered by MediResource™. This is your source for information on a wide range of natural health products. | Welcome to the Natural Health Products information database, powered by MediResource™. This is your source for information on a wide range
     * of natural health products.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \mriNaturalProd\StructType\GetNaturalProdList $parameters
     * @return \mriNaturalProd\StructType\GetNaturalProdListResponse|bool
     */
    public function GetNaturalProdList(\mriNaturalProd\StructType\GetNaturalProdList $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetNaturalProdList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetNaturalProdDetails
     * Meta informations extracted from the WSDL
     * - documentation: Natural Products Details | Natural Products Details | Natural Products Details
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \mriNaturalProd\StructType\GetNaturalProdDetails $parameters
     * @return \mriNaturalProd\StructType\GetNaturalProdDetailsResponse|bool
     */
    public function GetNaturalProdDetails(\mriNaturalProd\StructType\GetNaturalProdDetails $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetNaturalProdDetails($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \mriNaturalProd\StructType\GetNaturalProdDetailsResponse|\mriNaturalProd\StructType\GetNaturalProdListResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
