<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://webservice.mediresource.com/mricommunitysupport.asmx?WSDL',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://webservice.mediresource.com/mricommunitysupport.asmx?WSDL',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => \mriCommunitySupport\ClassMap::get(),
);
/**
 * Samples for Get ServiceType
 */
$get = new \mriCommunitySupport\ServiceType\Get($options);
/**
 * Sample call for GetSelectBoxes operation/method
 */
if ($get->GetSelectBoxes(new \mriCommunitySupport\StructType\GetSelectBoxes()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetCities operation/method
 */
if ($get->GetCities(new \mriCommunitySupport\StructType\GetCities()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetDetails operation/method
 */
if ($get->GetDetails(new \mriCommunitySupport\StructType\GetDetails()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetGlobalSearch operation/method
 */
if ($get->GetGlobalSearch(new \mriCommunitySupport\StructType\GetGlobalSearch()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
