<?php

namespace mriCommunitySupport\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GetSelectBoxes
     * Meta informations extracted from the WSDL
     * - documentation: Community Support Drop Downs | Community Support Drop Downs | Community Support Drop Downs
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \mriCommunitySupport\StructType\GetSelectBoxes $parameters
     * @return \mriCommunitySupport\StructType\GetSelectBoxesResponse|bool
     */
    public function GetSelectBoxes(\mriCommunitySupport\StructType\GetSelectBoxes $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetSelectBoxes($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCities
     * Meta informations extracted from the WSDL
     * - documentation: Community Support Cities | Community Support Cities | Community Support Cities
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \mriCommunitySupport\StructType\GetCities $parameters
     * @return \mriCommunitySupport\StructType\GetCitiesResponse|bool
     */
    public function GetCities(\mriCommunitySupport\StructType\GetCities $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetCities($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetDetails
     * Meta informations extracted from the WSDL
     * - documentation: Community Support Details | Community Support Details | Community Support Details
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \mriCommunitySupport\StructType\GetDetails $parameters
     * @return \mriCommunitySupport\StructType\GetDetailsResponse|bool
     */
    public function GetDetails(\mriCommunitySupport\StructType\GetDetails $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetDetails($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetGlobalSearch
     * Meta informations extracted from the WSDL
     * - documentation: Community Support Global Search | Community Support Global Search | Community Support Global Search
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \mriCommunitySupport\StructType\GetGlobalSearch $parameters
     * @return \mriCommunitySupport\StructType\GetGlobalSearchResponse|bool
     */
    public function GetGlobalSearch(\mriCommunitySupport\StructType\GetGlobalSearch $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetGlobalSearch($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \mriCommunitySupport\StructType\GetCitiesResponse|\mriCommunitySupport\StructType\GetDetailsResponse|\mriCommunitySupport\StructType\GetGlobalSearchResponse|\mriCommunitySupport\StructType\GetSelectBoxesResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
