<?php

namespace mriMedications\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for mriDINResult StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:mriDINResult
 * @subpackage Structs
 */
class MriDINResult extends AbstractStructBase
{
    /**
     * The ErrorCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ErrorCode;
    /**
     * The ErrorMessage
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ErrorMessage;
    /**
     * The DINItems
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \mriMedications\ArrayType\ArrayOfMriDINItem
     */
    public $DINItems;
    /**
     * Constructor method for mriDINResult
     * @uses MriDINResult::setErrorCode()
     * @uses MriDINResult::setErrorMessage()
     * @uses MriDINResult::setDINItems()
     * @param string $errorCode
     * @param string $errorMessage
     * @param \mriMedications\ArrayType\ArrayOfMriDINItem $dINItems
     */
    public function __construct($errorCode = null, $errorMessage = null, \mriMedications\ArrayType\ArrayOfMriDINItem $dINItems = null)
    {
        $this
            ->setErrorCode($errorCode)
            ->setErrorMessage($errorMessage)
            ->setDINItems($dINItems);
    }
    /**
     * Get ErrorCode value
     * @return string|null
     */
    public function getErrorCode()
    {
        return $this->ErrorCode;
    }
    /**
     * Set ErrorCode value
     * @param string $errorCode
     * @return \mriMedications\StructType\MriDINResult
     */
    public function setErrorCode($errorCode = null)
    {
        // validation for constraint: string
        if (!is_null($errorCode) && !is_string($errorCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($errorCode)), __LINE__);
        }
        $this->ErrorCode = $errorCode;
        return $this;
    }
    /**
     * Get ErrorMessage value
     * @return string|null
     */
    public function getErrorMessage()
    {
        return $this->ErrorMessage;
    }
    /**
     * Set ErrorMessage value
     * @param string $errorMessage
     * @return \mriMedications\StructType\MriDINResult
     */
    public function setErrorMessage($errorMessage = null)
    {
        // validation for constraint: string
        if (!is_null($errorMessage) && !is_string($errorMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($errorMessage)), __LINE__);
        }
        $this->ErrorMessage = $errorMessage;
        return $this;
    }
    /**
     * Get DINItems value
     * @return \mriMedications\ArrayType\ArrayOfMriDINItem|null
     */
    public function getDINItems()
    {
        return $this->DINItems;
    }
    /**
     * Set DINItems value
     * @param \mriMedications\ArrayType\ArrayOfMriDINItem $dINItems
     * @return \mriMedications\StructType\MriDINResult
     */
    public function setDINItems(\mriMedications\ArrayType\ArrayOfMriDINItem $dINItems = null)
    {
        $this->DINItems = $dINItems;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \mriMedications\StructType\MriDINResult
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
