<?php

namespace mriMedications\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GetDrugList
     * Meta informations extracted from the WSDL
     * - documentation: Welcome to our Prescription Drug Info, powered by MediResource™. This is your source for easy-to-use information on Canadian prescription drugs. | Welcome to our Prescription Drug Info, powered by MediResource™. This is your
     * source for easy-to-use information on Canadian prescription drugs. | Welcome to our Prescription Drug Info, powered by MediResource™. This is your source for easy-to-use information on Canadian prescription drugs.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \mriMedications\StructType\GetDrugList $parameters
     * @return \mriMedications\StructType\GetDrugListResponse|bool
     */
    public function GetDrugList(\mriMedications\StructType\GetDrugList $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetDrugList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetDrugDetailsDIN
     * Meta informations extracted from the WSDL
     * - documentation: Get drug details by DIN number. | Get drug details by DIN number. | Get drug details by DIN number.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \mriMedications\StructType\GetDrugDetailsDIN $parameters
     * @return \mriMedications\StructType\GetDrugDetailsDINResponse|bool
     */
    public function GetDrugDetailsDIN(\mriMedications\StructType\GetDrugDetailsDIN $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetDrugDetailsDIN($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetDrugListDIN
     * Meta informations extracted from the WSDL
     * - documentation: Drug List searching by DIN number. | Drug List searching by DIN number. | Drug List searching by DIN number.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \mriMedications\StructType\GetDrugListDIN $parameters
     * @return \mriMedications\StructType\GetDrugListDINResponse|bool
     */
    public function GetDrugListDIN(\mriMedications\StructType\GetDrugListDIN $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetDrugListDIN($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetDrugDetails
     * Meta informations extracted from the WSDL
     * - documentation: Brand Name Details | Brand Name Details | Brand Name Details
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \mriMedications\StructType\GetDrugDetails $parameters
     * @return \mriMedications\StructType\GetDrugDetailsResponse|bool
     */
    public function GetDrugDetails(\mriMedications\StructType\GetDrugDetails $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetDrugDetails($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetDINList
     * Meta informations extracted from the WSDL
     * - documentation: Drug List searching by DIN number. | Drug List searching by DIN number. | Drug List searching by DIN number.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \mriMedications\StructType\GetDINList $parameters
     * @return \mriMedications\StructType\GetDINListResponse|bool
     */
    public function GetDINList(\mriMedications\StructType\GetDINList $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetDINList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetDrugList_TS
     * Meta informations extracted from the WSDL
     * - documentation: Welcome to our Prescription Drug Info, powered by MediResource™. This is your source for easy-to-use information on Canadian prescription drugs. (Toronto Star) | Welcome to our Prescription Drug Info, powered by MediResource™.
     * This is your source for easy-to-use information on Canadian prescription drugs. (Toronto Star) | Welcome to our Prescription Drug Info, powered by MediResource™. This is your source for easy-to-use information on Canadian prescription drugs.
     * (Toronto Star)
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \mriMedications\StructType\GetDrugList_TS $parameters
     * @return \mriMedications\StructType\GetDrugList_TSResponse|bool
     */
    public function GetDrugList_TS(\mriMedications\StructType\GetDrugList_TS $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetDrugList_TS($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetDrugDetails_TS
     * Meta informations extracted from the WSDL
     * - documentation: Brand Name Details. (Toronto Star) | Brand Name Details. (Toronto Star) | Brand Name Details. (Toronto Star)
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \mriMedications\StructType\GetDrugDetails_TS $parameters
     * @return \mriMedications\StructType\GetDrugDetails_TSResponse|bool
     */
    public function GetDrugDetails_TS(\mriMedications\StructType\GetDrugDetails_TS $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetDrugDetails_TS($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \mriMedications\StructType\GetDINListResponse|\mriMedications\StructType\GetDrugDetailsDINResponse|\mriMedications\StructType\GetDrugDetailsResponse|\mriMedications\StructType\GetDrugDetails_TSResponse|\mriMedications\StructType\GetDrugListDINResponse|\mriMedications\StructType\GetDrugListResponse|\mriMedications\StructType\GetDrugList_TSResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
