<?php

namespace mriMedications\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for mriChannelItem StructType
 * @subpackage Structs
 */
class MriChannelItem extends AbstractStructBase
{
    /**
     * The info
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $info;
    /**
     * The displayname
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $displayname;
    /**
     * The displaynameA
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $displaynameA;
    /**
     * The id
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $id;
    /**
     * The brandname
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $brandname;
    /**
     * The brandnameid
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $brandnameid;
    /**
     * The commonname
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $commonname;
    /**
     * The DIN
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \mriMedications\StructType\MriDINItem[]
     */
    public $DIN;
    /**
     * The teaser
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $teaser;
    /**
     * The indication
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $indication;
    /**
     * The availableform
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $availableform;
    /**
     * The dosage
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $dosage;
    /**
     * The contraindications
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $contraindications;
    /**
     * The adverseeffects
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $adverseeffects;
    /**
     * The warnings
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $warnings;
    /**
     * The precautions
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $precautions;
    /**
     * The emptyset
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $emptyset;
    /**
     * The errorstring
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $errorstring;
    /**
     * The brands
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \mriMedications\StructType\MriBrand[]
     */
    public $brands;
    /**
     * The MedbLink
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MedbLink;
    /**
     * Constructor method for mriChannelItem
     * @uses MriChannelItem::setInfo()
     * @uses MriChannelItem::setDisplayname()
     * @uses MriChannelItem::setDisplaynameA()
     * @uses MriChannelItem::setId()
     * @uses MriChannelItem::setBrandname()
     * @uses MriChannelItem::setBrandnameid()
     * @uses MriChannelItem::setCommonname()
     * @uses MriChannelItem::setDIN()
     * @uses MriChannelItem::setTeaser()
     * @uses MriChannelItem::setIndication()
     * @uses MriChannelItem::setAvailableform()
     * @uses MriChannelItem::setDosage()
     * @uses MriChannelItem::setContraindications()
     * @uses MriChannelItem::setAdverseeffects()
     * @uses MriChannelItem::setWarnings()
     * @uses MriChannelItem::setPrecautions()
     * @uses MriChannelItem::setEmptyset()
     * @uses MriChannelItem::setErrorstring()
     * @uses MriChannelItem::setBrands()
     * @uses MriChannelItem::setMedbLink()
     * @param string $info
     * @param string $displayname
     * @param string $displaynameA
     * @param string $id
     * @param string $brandname
     * @param string $brandnameid
     * @param string $commonname
     * @param \mriMedications\StructType\MriDINItem[] $dIN
     * @param string $teaser
     * @param string $indication
     * @param string $availableform
     * @param string $dosage
     * @param string $contraindications
     * @param string $adverseeffects
     * @param string $warnings
     * @param string $precautions
     * @param string $emptyset
     * @param string $errorstring
     * @param \mriMedications\StructType\MriBrand[] $brands
     * @param string $medbLink
     */
    public function __construct($info = null, $displayname = null, $displaynameA = null, $id = null, $brandname = null, $brandnameid = null, $commonname = null, array $dIN = array(), $teaser = null, $indication = null, $availableform = null, $dosage = null, $contraindications = null, $adverseeffects = null, $warnings = null, $precautions = null, $emptyset = null, $errorstring = null, array $brands = array(), $medbLink = null)
    {
        $this
            ->setInfo($info)
            ->setDisplayname($displayname)
            ->setDisplaynameA($displaynameA)
            ->setId($id)
            ->setBrandname($brandname)
            ->setBrandnameid($brandnameid)
            ->setCommonname($commonname)
            ->setDIN($dIN)
            ->setTeaser($teaser)
            ->setIndication($indication)
            ->setAvailableform($availableform)
            ->setDosage($dosage)
            ->setContraindications($contraindications)
            ->setAdverseeffects($adverseeffects)
            ->setWarnings($warnings)
            ->setPrecautions($precautions)
            ->setEmptyset($emptyset)
            ->setErrorstring($errorstring)
            ->setBrands($brands)
            ->setMedbLink($medbLink);
    }
    /**
     * Get info value
     * @return string|null
     */
    public function getInfo()
    {
        return $this->info;
    }
    /**
     * Set info value
     * @param string $info
     * @return \mriMedications\StructType\MriChannelItem
     */
    public function setInfo($info = null)
    {
        // validation for constraint: string
        if (!is_null($info) && !is_string($info)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($info)), __LINE__);
        }
        $this->info = $info;
        return $this;
    }
    /**
     * Get displayname value
     * @return string|null
     */
    public function getDisplayname()
    {
        return $this->displayname;
    }
    /**
     * Set displayname value
     * @param string $displayname
     * @return \mriMedications\StructType\MriChannelItem
     */
    public function setDisplayname($displayname = null)
    {
        // validation for constraint: string
        if (!is_null($displayname) && !is_string($displayname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($displayname)), __LINE__);
        }
        $this->displayname = $displayname;
        return $this;
    }
    /**
     * Get displaynameA value
     * @return string|null
     */
    public function getDisplaynameA()
    {
        return $this->displaynameA;
    }
    /**
     * Set displaynameA value
     * @param string $displaynameA
     * @return \mriMedications\StructType\MriChannelItem
     */
    public function setDisplaynameA($displaynameA = null)
    {
        // validation for constraint: string
        if (!is_null($displaynameA) && !is_string($displaynameA)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($displaynameA)), __LINE__);
        }
        $this->displaynameA = $displaynameA;
        return $this;
    }
    /**
     * Get id value
     * @return string|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \mriMedications\StructType\MriChannelItem
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get brandname value
     * @return string|null
     */
    public function getBrandname()
    {
        return $this->brandname;
    }
    /**
     * Set brandname value
     * @param string $brandname
     * @return \mriMedications\StructType\MriChannelItem
     */
    public function setBrandname($brandname = null)
    {
        // validation for constraint: string
        if (!is_null($brandname) && !is_string($brandname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($brandname)), __LINE__);
        }
        $this->brandname = $brandname;
        return $this;
    }
    /**
     * Get brandnameid value
     * @return string|null
     */
    public function getBrandnameid()
    {
        return $this->brandnameid;
    }
    /**
     * Set brandnameid value
     * @param string $brandnameid
     * @return \mriMedications\StructType\MriChannelItem
     */
    public function setBrandnameid($brandnameid = null)
    {
        // validation for constraint: string
        if (!is_null($brandnameid) && !is_string($brandnameid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($brandnameid)), __LINE__);
        }
        $this->brandnameid = $brandnameid;
        return $this;
    }
    /**
     * Get commonname value
     * @return string|null
     */
    public function getCommonname()
    {
        return $this->commonname;
    }
    /**
     * Set commonname value
     * @param string $commonname
     * @return \mriMedications\StructType\MriChannelItem
     */
    public function setCommonname($commonname = null)
    {
        // validation for constraint: string
        if (!is_null($commonname) && !is_string($commonname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($commonname)), __LINE__);
        }
        $this->commonname = $commonname;
        return $this;
    }
    /**
     * Get DIN value
     * @return \mriMedications\StructType\MriDINItem[]|null
     */
    public function getDIN()
    {
        return $this->DIN;
    }
    /**
     * Set DIN value
     * @throws \InvalidArgumentException
     * @param \mriMedications\StructType\MriDINItem[] $dIN
     * @return \mriMedications\StructType\MriChannelItem
     */
    public function setDIN(array $dIN = array())
    {
        foreach ($dIN as $mriChannelItemDINItem) {
            // validation for constraint: itemType
            if (!$mriChannelItemDINItem instanceof \mriMedications\StructType\MriDINItem) {
                throw new \InvalidArgumentException(sprintf('The DIN property can only contain items of \mriMedications\StructType\MriDINItem, "%s" given', is_object($mriChannelItemDINItem) ? get_class($mriChannelItemDINItem) : gettype($mriChannelItemDINItem)), __LINE__);
            }
        }
        $this->DIN = $dIN;
        return $this;
    }
    /**
     * Add item to DIN value
     * @throws \InvalidArgumentException
     * @param \mriMedications\StructType\MriDINItem $item
     * @return \mriMedications\StructType\MriChannelItem
     */
    public function addToDIN(\mriMedications\StructType\MriDINItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \mriMedications\StructType\MriDINItem) {
            throw new \InvalidArgumentException(sprintf('The DIN property can only contain items of \mriMedications\StructType\MriDINItem, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->DIN[] = $item;
        return $this;
    }
    /**
     * Get teaser value
     * @return string|null
     */
    public function getTeaser()
    {
        return $this->teaser;
    }
    /**
     * Set teaser value
     * @param string $teaser
     * @return \mriMedications\StructType\MriChannelItem
     */
    public function setTeaser($teaser = null)
    {
        // validation for constraint: string
        if (!is_null($teaser) && !is_string($teaser)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($teaser)), __LINE__);
        }
        $this->teaser = $teaser;
        return $this;
    }
    /**
     * Get indication value
     * @return string|null
     */
    public function getIndication()
    {
        return $this->indication;
    }
    /**
     * Set indication value
     * @param string $indication
     * @return \mriMedications\StructType\MriChannelItem
     */
    public function setIndication($indication = null)
    {
        // validation for constraint: string
        if (!is_null($indication) && !is_string($indication)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($indication)), __LINE__);
        }
        $this->indication = $indication;
        return $this;
    }
    /**
     * Get availableform value
     * @return string|null
     */
    public function getAvailableform()
    {
        return $this->availableform;
    }
    /**
     * Set availableform value
     * @param string $availableform
     * @return \mriMedications\StructType\MriChannelItem
     */
    public function setAvailableform($availableform = null)
    {
        // validation for constraint: string
        if (!is_null($availableform) && !is_string($availableform)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($availableform)), __LINE__);
        }
        $this->availableform = $availableform;
        return $this;
    }
    /**
     * Get dosage value
     * @return string|null
     */
    public function getDosage()
    {
        return $this->dosage;
    }
    /**
     * Set dosage value
     * @param string $dosage
     * @return \mriMedications\StructType\MriChannelItem
     */
    public function setDosage($dosage = null)
    {
        // validation for constraint: string
        if (!is_null($dosage) && !is_string($dosage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dosage)), __LINE__);
        }
        $this->dosage = $dosage;
        return $this;
    }
    /**
     * Get contraindications value
     * @return string|null
     */
    public function getContraindications()
    {
        return $this->contraindications;
    }
    /**
     * Set contraindications value
     * @param string $contraindications
     * @return \mriMedications\StructType\MriChannelItem
     */
    public function setContraindications($contraindications = null)
    {
        // validation for constraint: string
        if (!is_null($contraindications) && !is_string($contraindications)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($contraindications)), __LINE__);
        }
        $this->contraindications = $contraindications;
        return $this;
    }
    /**
     * Get adverseeffects value
     * @return string|null
     */
    public function getAdverseeffects()
    {
        return $this->adverseeffects;
    }
    /**
     * Set adverseeffects value
     * @param string $adverseeffects
     * @return \mriMedications\StructType\MriChannelItem
     */
    public function setAdverseeffects($adverseeffects = null)
    {
        // validation for constraint: string
        if (!is_null($adverseeffects) && !is_string($adverseeffects)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($adverseeffects)), __LINE__);
        }
        $this->adverseeffects = $adverseeffects;
        return $this;
    }
    /**
     * Get warnings value
     * @return string|null
     */
    public function getWarnings()
    {
        return $this->warnings;
    }
    /**
     * Set warnings value
     * @param string $warnings
     * @return \mriMedications\StructType\MriChannelItem
     */
    public function setWarnings($warnings = null)
    {
        // validation for constraint: string
        if (!is_null($warnings) && !is_string($warnings)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($warnings)), __LINE__);
        }
        $this->warnings = $warnings;
        return $this;
    }
    /**
     * Get precautions value
     * @return string|null
     */
    public function getPrecautions()
    {
        return $this->precautions;
    }
    /**
     * Set precautions value
     * @param string $precautions
     * @return \mriMedications\StructType\MriChannelItem
     */
    public function setPrecautions($precautions = null)
    {
        // validation for constraint: string
        if (!is_null($precautions) && !is_string($precautions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($precautions)), __LINE__);
        }
        $this->precautions = $precautions;
        return $this;
    }
    /**
     * Get emptyset value
     * @return string|null
     */
    public function getEmptyset()
    {
        return $this->emptyset;
    }
    /**
     * Set emptyset value
     * @param string $emptyset
     * @return \mriMedications\StructType\MriChannelItem
     */
    public function setEmptyset($emptyset = null)
    {
        // validation for constraint: string
        if (!is_null($emptyset) && !is_string($emptyset)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($emptyset)), __LINE__);
        }
        $this->emptyset = $emptyset;
        return $this;
    }
    /**
     * Get errorstring value
     * @return string|null
     */
    public function getErrorstring()
    {
        return $this->errorstring;
    }
    /**
     * Set errorstring value
     * @param string $errorstring
     * @return \mriMedications\StructType\MriChannelItem
     */
    public function setErrorstring($errorstring = null)
    {
        // validation for constraint: string
        if (!is_null($errorstring) && !is_string($errorstring)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($errorstring)), __LINE__);
        }
        $this->errorstring = $errorstring;
        return $this;
    }
    /**
     * Get brands value
     * @return \mriMedications\StructType\MriBrand[]|null
     */
    public function getBrands()
    {
        return $this->brands;
    }
    /**
     * Set brands value
     * @throws \InvalidArgumentException
     * @param \mriMedications\StructType\MriBrand[] $brands
     * @return \mriMedications\StructType\MriChannelItem
     */
    public function setBrands(array $brands = array())
    {
        foreach ($brands as $mriChannelItemBrandsItem) {
            // validation for constraint: itemType
            if (!$mriChannelItemBrandsItem instanceof \mriMedications\StructType\MriBrand) {
                throw new \InvalidArgumentException(sprintf('The brands property can only contain items of \mriMedications\StructType\MriBrand, "%s" given', is_object($mriChannelItemBrandsItem) ? get_class($mriChannelItemBrandsItem) : gettype($mriChannelItemBrandsItem)), __LINE__);
            }
        }
        $this->brands = $brands;
        return $this;
    }
    /**
     * Add item to brands value
     * @throws \InvalidArgumentException
     * @param \mriMedications\StructType\MriBrand $item
     * @return \mriMedications\StructType\MriChannelItem
     */
    public function addToBrands(\mriMedications\StructType\MriBrand $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \mriMedications\StructType\MriBrand) {
            throw new \InvalidArgumentException(sprintf('The brands property can only contain items of \mriMedications\StructType\MriBrand, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->brands[] = $item;
        return $this;
    }
    /**
     * Get MedbLink value
     * @return string|null
     */
    public function getMedbLink()
    {
        return $this->MedbLink;
    }
    /**
     * Set MedbLink value
     * @param string $medbLink
     * @return \mriMedications\StructType\MriChannelItem
     */
    public function setMedbLink($medbLink = null)
    {
        // validation for constraint: string
        if (!is_null($medbLink) && !is_string($medbLink)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($medbLink)), __LINE__);
        }
        $this->MedbLink = $medbLink;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \mriMedications\StructType\MriChannelItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
