<?php

namespace mriMedications\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for mriChannel StructType
 * @subpackage Structs
 */
class MriChannel extends AbstractStructBase
{
    /**
     * The title
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $title;
    /**
     * The link
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $link;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The introduction
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $introduction;
    /**
     * The recordcount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $recordcount;
    /**
     * The alpha_text
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $alpha_text;
    /**
     * The search_box
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $search_box;
    /**
     * The search_text
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $search_text;
    /**
     * The search_by_alpha
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $search_by_alpha;
    /**
     * The brandname_title
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $brandname_title;
    /**
     * The commonname_title
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $commonname_title;
    /**
     * The indication_title
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $indication_title;
    /**
     * The dosage_title
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $dosage_title;
    /**
     * The availableform_title
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $availableform_title;
    /**
     * The contraindications_title
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $contraindications_title;
    /**
     * The adverseeffects_title
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $adverseeffects_title;
    /**
     * The warnings_title
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $warnings_title;
    /**
     * The precautions_title
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $precautions_title;
    /**
     * The searchbyalpha_title
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $searchbyalpha_title;
    /**
     * The disclaimer
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $disclaimer;
    /**
     * The search_DINbox
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $search_DINbox;
    /**
     * The drugs
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \mriMedications\StructType\MriChannelItem[]
     */
    public $drugs;
    /**
     * Constructor method for mriChannel
     * @uses MriChannel::setTitle()
     * @uses MriChannel::setLink()
     * @uses MriChannel::setDescription()
     * @uses MriChannel::setIntroduction()
     * @uses MriChannel::setRecordcount()
     * @uses MriChannel::setAlpha_text()
     * @uses MriChannel::setSearch_box()
     * @uses MriChannel::setSearch_text()
     * @uses MriChannel::setSearch_by_alpha()
     * @uses MriChannel::setBrandname_title()
     * @uses MriChannel::setCommonname_title()
     * @uses MriChannel::setIndication_title()
     * @uses MriChannel::setDosage_title()
     * @uses MriChannel::setAvailableform_title()
     * @uses MriChannel::setContraindications_title()
     * @uses MriChannel::setAdverseeffects_title()
     * @uses MriChannel::setWarnings_title()
     * @uses MriChannel::setPrecautions_title()
     * @uses MriChannel::setSearchbyalpha_title()
     * @uses MriChannel::setDisclaimer()
     * @uses MriChannel::setSearch_DINbox()
     * @uses MriChannel::setDrugs()
     * @param string $title
     * @param string $link
     * @param string $description
     * @param string $introduction
     * @param string $recordcount
     * @param string $alpha_text
     * @param string $search_box
     * @param string $search_text
     * @param string $search_by_alpha
     * @param string $brandname_title
     * @param string $commonname_title
     * @param string $indication_title
     * @param string $dosage_title
     * @param string $availableform_title
     * @param string $contraindications_title
     * @param string $adverseeffects_title
     * @param string $warnings_title
     * @param string $precautions_title
     * @param string $searchbyalpha_title
     * @param string $disclaimer
     * @param string $search_DINbox
     * @param \mriMedications\StructType\MriChannelItem[] $drugs
     */
    public function __construct($title = null, $link = null, $description = null, $introduction = null, $recordcount = null, $alpha_text = null, $search_box = null, $search_text = null, $search_by_alpha = null, $brandname_title = null, $commonname_title = null, $indication_title = null, $dosage_title = null, $availableform_title = null, $contraindications_title = null, $adverseeffects_title = null, $warnings_title = null, $precautions_title = null, $searchbyalpha_title = null, $disclaimer = null, $search_DINbox = null, array $drugs = array())
    {
        $this
            ->setTitle($title)
            ->setLink($link)
            ->setDescription($description)
            ->setIntroduction($introduction)
            ->setRecordcount($recordcount)
            ->setAlpha_text($alpha_text)
            ->setSearch_box($search_box)
            ->setSearch_text($search_text)
            ->setSearch_by_alpha($search_by_alpha)
            ->setBrandname_title($brandname_title)
            ->setCommonname_title($commonname_title)
            ->setIndication_title($indication_title)
            ->setDosage_title($dosage_title)
            ->setAvailableform_title($availableform_title)
            ->setContraindications_title($contraindications_title)
            ->setAdverseeffects_title($adverseeffects_title)
            ->setWarnings_title($warnings_title)
            ->setPrecautions_title($precautions_title)
            ->setSearchbyalpha_title($searchbyalpha_title)
            ->setDisclaimer($disclaimer)
            ->setSearch_DINbox($search_DINbox)
            ->setDrugs($drugs);
    }
    /**
     * Get title value
     * @return string|null
     */
    public function getTitle()
    {
        return $this->title;
    }
    /**
     * Set title value
     * @param string $title
     * @return \mriMedications\StructType\MriChannel
     */
    public function setTitle($title = null)
    {
        // validation for constraint: string
        if (!is_null($title) && !is_string($title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($title)), __LINE__);
        }
        $this->title = $title;
        return $this;
    }
    /**
     * Get link value
     * @return string|null
     */
    public function getLink()
    {
        return $this->link;
    }
    /**
     * Set link value
     * @param string $link
     * @return \mriMedications\StructType\MriChannel
     */
    public function setLink($link = null)
    {
        // validation for constraint: string
        if (!is_null($link) && !is_string($link)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($link)), __LINE__);
        }
        $this->link = $link;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \mriMedications\StructType\MriChannel
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get introduction value
     * @return string|null
     */
    public function getIntroduction()
    {
        return $this->introduction;
    }
    /**
     * Set introduction value
     * @param string $introduction
     * @return \mriMedications\StructType\MriChannel
     */
    public function setIntroduction($introduction = null)
    {
        // validation for constraint: string
        if (!is_null($introduction) && !is_string($introduction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($introduction)), __LINE__);
        }
        $this->introduction = $introduction;
        return $this;
    }
    /**
     * Get recordcount value
     * @return string|null
     */
    public function getRecordcount()
    {
        return $this->recordcount;
    }
    /**
     * Set recordcount value
     * @param string $recordcount
     * @return \mriMedications\StructType\MriChannel
     */
    public function setRecordcount($recordcount = null)
    {
        // validation for constraint: string
        if (!is_null($recordcount) && !is_string($recordcount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($recordcount)), __LINE__);
        }
        $this->recordcount = $recordcount;
        return $this;
    }
    /**
     * Get alpha_text value
     * @return string|null
     */
    public function getAlpha_text()
    {
        return $this->alpha_text;
    }
    /**
     * Set alpha_text value
     * @param string $alpha_text
     * @return \mriMedications\StructType\MriChannel
     */
    public function setAlpha_text($alpha_text = null)
    {
        // validation for constraint: string
        if (!is_null($alpha_text) && !is_string($alpha_text)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($alpha_text)), __LINE__);
        }
        $this->alpha_text = $alpha_text;
        return $this;
    }
    /**
     * Get search_box value
     * @return string|null
     */
    public function getSearch_box()
    {
        return $this->search_box;
    }
    /**
     * Set search_box value
     * @param string $search_box
     * @return \mriMedications\StructType\MriChannel
     */
    public function setSearch_box($search_box = null)
    {
        // validation for constraint: string
        if (!is_null($search_box) && !is_string($search_box)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($search_box)), __LINE__);
        }
        $this->search_box = $search_box;
        return $this;
    }
    /**
     * Get search_text value
     * @return string|null
     */
    public function getSearch_text()
    {
        return $this->search_text;
    }
    /**
     * Set search_text value
     * @param string $search_text
     * @return \mriMedications\StructType\MriChannel
     */
    public function setSearch_text($search_text = null)
    {
        // validation for constraint: string
        if (!is_null($search_text) && !is_string($search_text)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($search_text)), __LINE__);
        }
        $this->search_text = $search_text;
        return $this;
    }
    /**
     * Get search_by_alpha value
     * @return string|null
     */
    public function getSearch_by_alpha()
    {
        return $this->search_by_alpha;
    }
    /**
     * Set search_by_alpha value
     * @param string $search_by_alpha
     * @return \mriMedications\StructType\MriChannel
     */
    public function setSearch_by_alpha($search_by_alpha = null)
    {
        // validation for constraint: string
        if (!is_null($search_by_alpha) && !is_string($search_by_alpha)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($search_by_alpha)), __LINE__);
        }
        $this->search_by_alpha = $search_by_alpha;
        return $this;
    }
    /**
     * Get brandname_title value
     * @return string|null
     */
    public function getBrandname_title()
    {
        return $this->brandname_title;
    }
    /**
     * Set brandname_title value
     * @param string $brandname_title
     * @return \mriMedications\StructType\MriChannel
     */
    public function setBrandname_title($brandname_title = null)
    {
        // validation for constraint: string
        if (!is_null($brandname_title) && !is_string($brandname_title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($brandname_title)), __LINE__);
        }
        $this->brandname_title = $brandname_title;
        return $this;
    }
    /**
     * Get commonname_title value
     * @return string|null
     */
    public function getCommonname_title()
    {
        return $this->commonname_title;
    }
    /**
     * Set commonname_title value
     * @param string $commonname_title
     * @return \mriMedications\StructType\MriChannel
     */
    public function setCommonname_title($commonname_title = null)
    {
        // validation for constraint: string
        if (!is_null($commonname_title) && !is_string($commonname_title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($commonname_title)), __LINE__);
        }
        $this->commonname_title = $commonname_title;
        return $this;
    }
    /**
     * Get indication_title value
     * @return string|null
     */
    public function getIndication_title()
    {
        return $this->indication_title;
    }
    /**
     * Set indication_title value
     * @param string $indication_title
     * @return \mriMedications\StructType\MriChannel
     */
    public function setIndication_title($indication_title = null)
    {
        // validation for constraint: string
        if (!is_null($indication_title) && !is_string($indication_title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($indication_title)), __LINE__);
        }
        $this->indication_title = $indication_title;
        return $this;
    }
    /**
     * Get dosage_title value
     * @return string|null
     */
    public function getDosage_title()
    {
        return $this->dosage_title;
    }
    /**
     * Set dosage_title value
     * @param string $dosage_title
     * @return \mriMedications\StructType\MriChannel
     */
    public function setDosage_title($dosage_title = null)
    {
        // validation for constraint: string
        if (!is_null($dosage_title) && !is_string($dosage_title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dosage_title)), __LINE__);
        }
        $this->dosage_title = $dosage_title;
        return $this;
    }
    /**
     * Get availableform_title value
     * @return string|null
     */
    public function getAvailableform_title()
    {
        return $this->availableform_title;
    }
    /**
     * Set availableform_title value
     * @param string $availableform_title
     * @return \mriMedications\StructType\MriChannel
     */
    public function setAvailableform_title($availableform_title = null)
    {
        // validation for constraint: string
        if (!is_null($availableform_title) && !is_string($availableform_title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($availableform_title)), __LINE__);
        }
        $this->availableform_title = $availableform_title;
        return $this;
    }
    /**
     * Get contraindications_title value
     * @return string|null
     */
    public function getContraindications_title()
    {
        return $this->contraindications_title;
    }
    /**
     * Set contraindications_title value
     * @param string $contraindications_title
     * @return \mriMedications\StructType\MriChannel
     */
    public function setContraindications_title($contraindications_title = null)
    {
        // validation for constraint: string
        if (!is_null($contraindications_title) && !is_string($contraindications_title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($contraindications_title)), __LINE__);
        }
        $this->contraindications_title = $contraindications_title;
        return $this;
    }
    /**
     * Get adverseeffects_title value
     * @return string|null
     */
    public function getAdverseeffects_title()
    {
        return $this->adverseeffects_title;
    }
    /**
     * Set adverseeffects_title value
     * @param string $adverseeffects_title
     * @return \mriMedications\StructType\MriChannel
     */
    public function setAdverseeffects_title($adverseeffects_title = null)
    {
        // validation for constraint: string
        if (!is_null($adverseeffects_title) && !is_string($adverseeffects_title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($adverseeffects_title)), __LINE__);
        }
        $this->adverseeffects_title = $adverseeffects_title;
        return $this;
    }
    /**
     * Get warnings_title value
     * @return string|null
     */
    public function getWarnings_title()
    {
        return $this->warnings_title;
    }
    /**
     * Set warnings_title value
     * @param string $warnings_title
     * @return \mriMedications\StructType\MriChannel
     */
    public function setWarnings_title($warnings_title = null)
    {
        // validation for constraint: string
        if (!is_null($warnings_title) && !is_string($warnings_title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($warnings_title)), __LINE__);
        }
        $this->warnings_title = $warnings_title;
        return $this;
    }
    /**
     * Get precautions_title value
     * @return string|null
     */
    public function getPrecautions_title()
    {
        return $this->precautions_title;
    }
    /**
     * Set precautions_title value
     * @param string $precautions_title
     * @return \mriMedications\StructType\MriChannel
     */
    public function setPrecautions_title($precautions_title = null)
    {
        // validation for constraint: string
        if (!is_null($precautions_title) && !is_string($precautions_title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($precautions_title)), __LINE__);
        }
        $this->precautions_title = $precautions_title;
        return $this;
    }
    /**
     * Get searchbyalpha_title value
     * @return string|null
     */
    public function getSearchbyalpha_title()
    {
        return $this->searchbyalpha_title;
    }
    /**
     * Set searchbyalpha_title value
     * @param string $searchbyalpha_title
     * @return \mriMedications\StructType\MriChannel
     */
    public function setSearchbyalpha_title($searchbyalpha_title = null)
    {
        // validation for constraint: string
        if (!is_null($searchbyalpha_title) && !is_string($searchbyalpha_title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($searchbyalpha_title)), __LINE__);
        }
        $this->searchbyalpha_title = $searchbyalpha_title;
        return $this;
    }
    /**
     * Get disclaimer value
     * @return string|null
     */
    public function getDisclaimer()
    {
        return $this->disclaimer;
    }
    /**
     * Set disclaimer value
     * @param string $disclaimer
     * @return \mriMedications\StructType\MriChannel
     */
    public function setDisclaimer($disclaimer = null)
    {
        // validation for constraint: string
        if (!is_null($disclaimer) && !is_string($disclaimer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($disclaimer)), __LINE__);
        }
        $this->disclaimer = $disclaimer;
        return $this;
    }
    /**
     * Get search_DINbox value
     * @return string|null
     */
    public function getSearch_DINbox()
    {
        return $this->search_DINbox;
    }
    /**
     * Set search_DINbox value
     * @param string $search_DINbox
     * @return \mriMedications\StructType\MriChannel
     */
    public function setSearch_DINbox($search_DINbox = null)
    {
        // validation for constraint: string
        if (!is_null($search_DINbox) && !is_string($search_DINbox)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($search_DINbox)), __LINE__);
        }
        $this->search_DINbox = $search_DINbox;
        return $this;
    }
    /**
     * Get drugs value
     * @return \mriMedications\StructType\MriChannelItem[]|null
     */
    public function getDrugs()
    {
        return $this->drugs;
    }
    /**
     * Set drugs value
     * @throws \InvalidArgumentException
     * @param \mriMedications\StructType\MriChannelItem[] $drugs
     * @return \mriMedications\StructType\MriChannel
     */
    public function setDrugs(array $drugs = array())
    {
        foreach ($drugs as $mriChannelDrugsItem) {
            // validation for constraint: itemType
            if (!$mriChannelDrugsItem instanceof \mriMedications\StructType\MriChannelItem) {
                throw new \InvalidArgumentException(sprintf('The drugs property can only contain items of \mriMedications\StructType\MriChannelItem, "%s" given', is_object($mriChannelDrugsItem) ? get_class($mriChannelDrugsItem) : gettype($mriChannelDrugsItem)), __LINE__);
            }
        }
        $this->drugs = $drugs;
        return $this;
    }
    /**
     * Add item to drugs value
     * @throws \InvalidArgumentException
     * @param \mriMedications\StructType\MriChannelItem $item
     * @return \mriMedications\StructType\MriChannel
     */
    public function addToDrugs(\mriMedications\StructType\MriChannelItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \mriMedications\StructType\MriChannelItem) {
            throw new \InvalidArgumentException(sprintf('The drugs property can only contain items of \mriMedications\StructType\MriChannelItem, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->drugs[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \mriMedications\StructType\MriChannel
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
