<?php

namespace mriMedications\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfMriDINItem ArrayType
 * @subpackage Arrays
 */
class ArrayOfMriDINItem extends AbstractStructArrayBase
{
    /**
     * The mriDINItem
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \mriMedications\StructType\MriDINItem[]
     */
    public $mriDINItem;
    /**
     * Constructor method for ArrayOfMriDINItem
     * @uses ArrayOfMriDINItem::setMriDINItem()
     * @param \mriMedications\StructType\MriDINItem[] $mriDINItem
     */
    public function __construct(array $mriDINItem = array())
    {
        $this
            ->setMriDINItem($mriDINItem);
    }
    /**
     * Get mriDINItem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \mriMedications\StructType\MriDINItem[]|null
     */
    public function getMriDINItem()
    {
        return isset($this->mriDINItem) ? $this->mriDINItem : null;
    }
    /**
     * Set mriDINItem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \mriMedications\StructType\MriDINItem[] $mriDINItem
     * @return \mriMedications\ArrayType\ArrayOfMriDINItem
     */
    public function setMriDINItem(array $mriDINItem = array())
    {
        foreach ($mriDINItem as $arrayOfMriDINItemMriDINItemItem) {
            // validation for constraint: itemType
            if (!$arrayOfMriDINItemMriDINItemItem instanceof \mriMedications\StructType\MriDINItem) {
                throw new \InvalidArgumentException(sprintf('The mriDINItem property can only contain items of \mriMedications\StructType\MriDINItem, "%s" given', is_object($arrayOfMriDINItemMriDINItemItem) ? get_class($arrayOfMriDINItemMriDINItemItem) : gettype($arrayOfMriDINItemMriDINItemItem)), __LINE__);
            }
        }
        if (is_null($mriDINItem) || (is_array($mriDINItem) && empty($mriDINItem))) {
            unset($this->mriDINItem);
        } else {
            $this->mriDINItem = $mriDINItem;
        }
        return $this;
    }
    /**
     * Add item to mriDINItem value
     * @throws \InvalidArgumentException
     * @param \mriMedications\StructType\MriDINItem $item
     * @return \mriMedications\ArrayType\ArrayOfMriDINItem
     */
    public function addToMriDINItem(\mriMedications\StructType\MriDINItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \mriMedications\StructType\MriDINItem) {
            throw new \InvalidArgumentException(sprintf('The mriDINItem property can only contain items of \mriMedications\StructType\MriDINItem, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->mriDINItem[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \mriMedications\StructType\MriDINItem|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \mriMedications\StructType\MriDINItem|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \mriMedications\StructType\MriDINItem|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \mriMedications\StructType\MriDINItem|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \mriMedications\StructType\MriDINItem|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string mriDINItem
     */
    public function getAttributeName()
    {
        return 'mriDINItem';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \mriMedications\ArrayType\ArrayOfMriDINItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
