<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://webservice.mediresource.com/mriMedications.asmx?WSDL',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://webservice.mediresource.com/mriMedications.asmx?WSDL',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => \mriMedications\ClassMap::get(),
);
/**
 * Samples for Get ServiceType
 */
$get = new \mriMedications\ServiceType\Get($options);
/**
 * Sample call for GetDrugList operation/method
 */
if ($get->GetDrugList(new \mriMedications\StructType\GetDrugList()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetDrugDetailsDIN operation/method
 */
if ($get->GetDrugDetailsDIN(new \mriMedications\StructType\GetDrugDetailsDIN()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetDrugListDIN operation/method
 */
if ($get->GetDrugListDIN(new \mriMedications\StructType\GetDrugListDIN()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetDrugDetails operation/method
 */
if ($get->GetDrugDetails(new \mriMedications\StructType\GetDrugDetails()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetDINList operation/method
 */
if ($get->GetDINList(new \mriMedications\StructType\GetDINList()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetDrugList_TS operation/method
 */
if ($get->GetDrugList_TS(new \mriMedications\StructType\GetDrugList_TS()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetDrugDetails_TS operation/method
 */
if ($get->GetDrugDetails_TS(new \mriMedications\StructType\GetDrugDetails_TS()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
