<?php

namespace mriConditions\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for mriChannel StructType
 * @subpackage Structs
 */
class MriChannel extends AbstractStructBase
{
    /**
     * The title
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $title;
    /**
     * The link
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $link;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The introduction
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $introduction;
    /**
     * The recordcount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $recordcount;
    /**
     * The alpha_text
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $alpha_text;
    /**
     * The search_box
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $search_box;
    /**
     * The search_text
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $search_text;
    /**
     * The facts_title
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $facts_title;
    /**
     * The causes_title
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $causes_title;
    /**
     * The symptoms_title
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $symptoms_title;
    /**
     * The diagnosis_title
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $diagnosis_title;
    /**
     * The treatment_title
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $treatment_title;
    /**
     * The search_by_alpha
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $search_by_alpha;
    /**
     * The disclaimer
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $disclaimer;
    /**
     * The last_updated_title
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $last_updated_title;
    /**
     * The artcl_refs_title
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $artcl_refs_title;
    /**
     * The conditions
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \mriConditions\StructType\MriChannelItem[]
     */
    public $conditions;
    /**
     * Constructor method for mriChannel
     * @uses MriChannel::setTitle()
     * @uses MriChannel::setLink()
     * @uses MriChannel::setDescription()
     * @uses MriChannel::setIntroduction()
     * @uses MriChannel::setRecordcount()
     * @uses MriChannel::setAlpha_text()
     * @uses MriChannel::setSearch_box()
     * @uses MriChannel::setSearch_text()
     * @uses MriChannel::setFacts_title()
     * @uses MriChannel::setCauses_title()
     * @uses MriChannel::setSymptoms_title()
     * @uses MriChannel::setDiagnosis_title()
     * @uses MriChannel::setTreatment_title()
     * @uses MriChannel::setSearch_by_alpha()
     * @uses MriChannel::setDisclaimer()
     * @uses MriChannel::setLast_updated_title()
     * @uses MriChannel::setArtcl_refs_title()
     * @uses MriChannel::setConditions()
     * @param string $title
     * @param string $link
     * @param string $description
     * @param string $introduction
     * @param string $recordcount
     * @param string $alpha_text
     * @param string $search_box
     * @param string $search_text
     * @param string $facts_title
     * @param string $causes_title
     * @param string $symptoms_title
     * @param string $diagnosis_title
     * @param string $treatment_title
     * @param string $search_by_alpha
     * @param string $disclaimer
     * @param string $last_updated_title
     * @param string $artcl_refs_title
     * @param \mriConditions\StructType\MriChannelItem[] $conditions
     */
    public function __construct($title = null, $link = null, $description = null, $introduction = null, $recordcount = null, $alpha_text = null, $search_box = null, $search_text = null, $facts_title = null, $causes_title = null, $symptoms_title = null, $diagnosis_title = null, $treatment_title = null, $search_by_alpha = null, $disclaimer = null, $last_updated_title = null, $artcl_refs_title = null, array $conditions = array())
    {
        $this
            ->setTitle($title)
            ->setLink($link)
            ->setDescription($description)
            ->setIntroduction($introduction)
            ->setRecordcount($recordcount)
            ->setAlpha_text($alpha_text)
            ->setSearch_box($search_box)
            ->setSearch_text($search_text)
            ->setFacts_title($facts_title)
            ->setCauses_title($causes_title)
            ->setSymptoms_title($symptoms_title)
            ->setDiagnosis_title($diagnosis_title)
            ->setTreatment_title($treatment_title)
            ->setSearch_by_alpha($search_by_alpha)
            ->setDisclaimer($disclaimer)
            ->setLast_updated_title($last_updated_title)
            ->setArtcl_refs_title($artcl_refs_title)
            ->setConditions($conditions);
    }
    /**
     * Get title value
     * @return string|null
     */
    public function getTitle()
    {
        return $this->title;
    }
    /**
     * Set title value
     * @param string $title
     * @return \mriConditions\StructType\MriChannel
     */
    public function setTitle($title = null)
    {
        // validation for constraint: string
        if (!is_null($title) && !is_string($title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($title)), __LINE__);
        }
        $this->title = $title;
        return $this;
    }
    /**
     * Get link value
     * @return string|null
     */
    public function getLink()
    {
        return $this->link;
    }
    /**
     * Set link value
     * @param string $link
     * @return \mriConditions\StructType\MriChannel
     */
    public function setLink($link = null)
    {
        // validation for constraint: string
        if (!is_null($link) && !is_string($link)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($link)), __LINE__);
        }
        $this->link = $link;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \mriConditions\StructType\MriChannel
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get introduction value
     * @return string|null
     */
    public function getIntroduction()
    {
        return $this->introduction;
    }
    /**
     * Set introduction value
     * @param string $introduction
     * @return \mriConditions\StructType\MriChannel
     */
    public function setIntroduction($introduction = null)
    {
        // validation for constraint: string
        if (!is_null($introduction) && !is_string($introduction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($introduction)), __LINE__);
        }
        $this->introduction = $introduction;
        return $this;
    }
    /**
     * Get recordcount value
     * @return string|null
     */
    public function getRecordcount()
    {
        return $this->recordcount;
    }
    /**
     * Set recordcount value
     * @param string $recordcount
     * @return \mriConditions\StructType\MriChannel
     */
    public function setRecordcount($recordcount = null)
    {
        // validation for constraint: string
        if (!is_null($recordcount) && !is_string($recordcount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($recordcount)), __LINE__);
        }
        $this->recordcount = $recordcount;
        return $this;
    }
    /**
     * Get alpha_text value
     * @return string|null
     */
    public function getAlpha_text()
    {
        return $this->alpha_text;
    }
    /**
     * Set alpha_text value
     * @param string $alpha_text
     * @return \mriConditions\StructType\MriChannel
     */
    public function setAlpha_text($alpha_text = null)
    {
        // validation for constraint: string
        if (!is_null($alpha_text) && !is_string($alpha_text)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($alpha_text)), __LINE__);
        }
        $this->alpha_text = $alpha_text;
        return $this;
    }
    /**
     * Get search_box value
     * @return string|null
     */
    public function getSearch_box()
    {
        return $this->search_box;
    }
    /**
     * Set search_box value
     * @param string $search_box
     * @return \mriConditions\StructType\MriChannel
     */
    public function setSearch_box($search_box = null)
    {
        // validation for constraint: string
        if (!is_null($search_box) && !is_string($search_box)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($search_box)), __LINE__);
        }
        $this->search_box = $search_box;
        return $this;
    }
    /**
     * Get search_text value
     * @return string|null
     */
    public function getSearch_text()
    {
        return $this->search_text;
    }
    /**
     * Set search_text value
     * @param string $search_text
     * @return \mriConditions\StructType\MriChannel
     */
    public function setSearch_text($search_text = null)
    {
        // validation for constraint: string
        if (!is_null($search_text) && !is_string($search_text)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($search_text)), __LINE__);
        }
        $this->search_text = $search_text;
        return $this;
    }
    /**
     * Get facts_title value
     * @return string|null
     */
    public function getFacts_title()
    {
        return $this->facts_title;
    }
    /**
     * Set facts_title value
     * @param string $facts_title
     * @return \mriConditions\StructType\MriChannel
     */
    public function setFacts_title($facts_title = null)
    {
        // validation for constraint: string
        if (!is_null($facts_title) && !is_string($facts_title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($facts_title)), __LINE__);
        }
        $this->facts_title = $facts_title;
        return $this;
    }
    /**
     * Get causes_title value
     * @return string|null
     */
    public function getCauses_title()
    {
        return $this->causes_title;
    }
    /**
     * Set causes_title value
     * @param string $causes_title
     * @return \mriConditions\StructType\MriChannel
     */
    public function setCauses_title($causes_title = null)
    {
        // validation for constraint: string
        if (!is_null($causes_title) && !is_string($causes_title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($causes_title)), __LINE__);
        }
        $this->causes_title = $causes_title;
        return $this;
    }
    /**
     * Get symptoms_title value
     * @return string|null
     */
    public function getSymptoms_title()
    {
        return $this->symptoms_title;
    }
    /**
     * Set symptoms_title value
     * @param string $symptoms_title
     * @return \mriConditions\StructType\MriChannel
     */
    public function setSymptoms_title($symptoms_title = null)
    {
        // validation for constraint: string
        if (!is_null($symptoms_title) && !is_string($symptoms_title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($symptoms_title)), __LINE__);
        }
        $this->symptoms_title = $symptoms_title;
        return $this;
    }
    /**
     * Get diagnosis_title value
     * @return string|null
     */
    public function getDiagnosis_title()
    {
        return $this->diagnosis_title;
    }
    /**
     * Set diagnosis_title value
     * @param string $diagnosis_title
     * @return \mriConditions\StructType\MriChannel
     */
    public function setDiagnosis_title($diagnosis_title = null)
    {
        // validation for constraint: string
        if (!is_null($diagnosis_title) && !is_string($diagnosis_title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($diagnosis_title)), __LINE__);
        }
        $this->diagnosis_title = $diagnosis_title;
        return $this;
    }
    /**
     * Get treatment_title value
     * @return string|null
     */
    public function getTreatment_title()
    {
        return $this->treatment_title;
    }
    /**
     * Set treatment_title value
     * @param string $treatment_title
     * @return \mriConditions\StructType\MriChannel
     */
    public function setTreatment_title($treatment_title = null)
    {
        // validation for constraint: string
        if (!is_null($treatment_title) && !is_string($treatment_title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($treatment_title)), __LINE__);
        }
        $this->treatment_title = $treatment_title;
        return $this;
    }
    /**
     * Get search_by_alpha value
     * @return string|null
     */
    public function getSearch_by_alpha()
    {
        return $this->search_by_alpha;
    }
    /**
     * Set search_by_alpha value
     * @param string $search_by_alpha
     * @return \mriConditions\StructType\MriChannel
     */
    public function setSearch_by_alpha($search_by_alpha = null)
    {
        // validation for constraint: string
        if (!is_null($search_by_alpha) && !is_string($search_by_alpha)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($search_by_alpha)), __LINE__);
        }
        $this->search_by_alpha = $search_by_alpha;
        return $this;
    }
    /**
     * Get disclaimer value
     * @return string|null
     */
    public function getDisclaimer()
    {
        return $this->disclaimer;
    }
    /**
     * Set disclaimer value
     * @param string $disclaimer
     * @return \mriConditions\StructType\MriChannel
     */
    public function setDisclaimer($disclaimer = null)
    {
        // validation for constraint: string
        if (!is_null($disclaimer) && !is_string($disclaimer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($disclaimer)), __LINE__);
        }
        $this->disclaimer = $disclaimer;
        return $this;
    }
    /**
     * Get last_updated_title value
     * @return string|null
     */
    public function getLast_updated_title()
    {
        return $this->last_updated_title;
    }
    /**
     * Set last_updated_title value
     * @param string $last_updated_title
     * @return \mriConditions\StructType\MriChannel
     */
    public function setLast_updated_title($last_updated_title = null)
    {
        // validation for constraint: string
        if (!is_null($last_updated_title) && !is_string($last_updated_title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($last_updated_title)), __LINE__);
        }
        $this->last_updated_title = $last_updated_title;
        return $this;
    }
    /**
     * Get artcl_refs_title value
     * @return string|null
     */
    public function getArtcl_refs_title()
    {
        return $this->artcl_refs_title;
    }
    /**
     * Set artcl_refs_title value
     * @param string $artcl_refs_title
     * @return \mriConditions\StructType\MriChannel
     */
    public function setArtcl_refs_title($artcl_refs_title = null)
    {
        // validation for constraint: string
        if (!is_null($artcl_refs_title) && !is_string($artcl_refs_title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($artcl_refs_title)), __LINE__);
        }
        $this->artcl_refs_title = $artcl_refs_title;
        return $this;
    }
    /**
     * Get conditions value
     * @return \mriConditions\StructType\MriChannelItem[]|null
     */
    public function getConditions()
    {
        return $this->conditions;
    }
    /**
     * Set conditions value
     * @throws \InvalidArgumentException
     * @param \mriConditions\StructType\MriChannelItem[] $conditions
     * @return \mriConditions\StructType\MriChannel
     */
    public function setConditions(array $conditions = array())
    {
        foreach ($conditions as $mriChannelConditionsItem) {
            // validation for constraint: itemType
            if (!$mriChannelConditionsItem instanceof \mriConditions\StructType\MriChannelItem) {
                throw new \InvalidArgumentException(sprintf('The conditions property can only contain items of \mriConditions\StructType\MriChannelItem, "%s" given', is_object($mriChannelConditionsItem) ? get_class($mriChannelConditionsItem) : gettype($mriChannelConditionsItem)), __LINE__);
            }
        }
        $this->conditions = $conditions;
        return $this;
    }
    /**
     * Add item to conditions value
     * @throws \InvalidArgumentException
     * @param \mriConditions\StructType\MriChannelItem $item
     * @return \mriConditions\StructType\MriChannel
     */
    public function addToConditions(\mriConditions\StructType\MriChannelItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \mriConditions\StructType\MriChannelItem) {
            throw new \InvalidArgumentException(sprintf('The conditions property can only contain items of \mriConditions\StructType\MriChannelItem, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->conditions[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \mriConditions\StructType\MriChannel
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
