<?php

namespace mriConditions\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GetDiseaseInfo
     * Meta informations extracted from the WSDL
     * - documentation: Welcome to our Condition Info, powered by MediResource™. This is your source for easy-to-understand information on hundreds of medical conditions. | Welcome to our Condition Info, powered by MediResource™. This is your source for
     * easy-to-understand information on hundreds of medical conditions. | Welcome to our Condition Info, powered by MediResource™. This is your source for easy-to-understand information on hundreds of medical conditions.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \mriConditions\StructType\GetDiseaseInfo $parameters
     * @return \mriConditions\StructType\GetDiseaseInfoResponse|bool
     */
    public function GetDiseaseInfo(\mriConditions\StructType\GetDiseaseInfo $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetDiseaseInfo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetDiseaseInfoICD10
     * Meta informations extracted from the WSDL
     * - documentation: Return disease details list by ICD 10 code. | Return disease details list by ICD 10 code. | Return disease details list by ICD 10 code.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \mriConditions\StructType\GetDiseaseInfoICD10 $parameters
     * @return \mriConditions\StructType\GetDiseaseInfoICD10Response|bool
     */
    public function GetDiseaseInfoICD10(\mriConditions\StructType\GetDiseaseInfoICD10 $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetDiseaseInfoICD10($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetDiseaseInfo_TS
     * Meta informations extracted from the WSDL
     * - documentation: Welcome to our Condition Info, powered by MediResource™. This is your source for easy-to-understand information on hundreds of medical conditions. (Toronto Star) | Welcome to our Condition Info, powered by MediResource™. This is
     * your source for easy-to-understand information on hundreds of medical conditions. (Toronto Star) | Welcome to our Condition Info, powered by MediResource™. This is your source for easy-to-understand information on hundreds of medical conditions.
     * (Toronto Star)
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \mriConditions\StructType\GetDiseaseInfo_TS $parameters
     * @return \mriConditions\StructType\GetDiseaseInfo_TSResponse|bool
     */
    public function GetDiseaseInfo_TS(\mriConditions\StructType\GetDiseaseInfo_TS $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetDiseaseInfo_TS($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \mriConditions\StructType\GetDiseaseInfoICD10Response|\mriConditions\StructType\GetDiseaseInfoResponse|\mriConditions\StructType\GetDiseaseInfo_TSResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
