<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the first needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientBase class (each generated ServiceType class extends this class)
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://webservice.mediresource.com/mridisease.asmx?WSDL',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc...
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://webservice.mediresource.com/mridisease.asmx?WSDL',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => \mriConditions\ClassMap::get(),
);
/**
 * Samples for Get ServiceType
 */
$get = new \mriConditions\ServiceType\Get($options);
/**
 * Sample call for GetDiseaseInfo operation/method
 */
if ($get->GetDiseaseInfo(new \mriConditions\StructType\GetDiseaseInfo()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetAllDiseaseList operation/method
 */
if ($get->GetAllDiseaseList(new \mriConditions\StructType\GetAllDiseaseList()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetDiseaseInfoICD10 operation/method
 */
if ($get->GetDiseaseInfoICD10(new \mriConditions\StructType\GetDiseaseInfoICD10()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
