<?php

namespace Path\pathServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Update pathServiceType
 * @package Path
 * @subpackage Services
 */
class PathUpdate extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named UpdateLoanFeeData
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Path\pathStructType\PathUpdateLoanFeeData $parameters
     * @return \Path\pathStructType\PathUpdateLoanFeeDataResponse|bool
     */
    public function UpdateLoanFeeData(\Path\pathStructType\PathUpdateLoanFeeData $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UpdateLoanFeeData($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateLockStatus
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Path\pathStructType\PathUpdateLockStatus $parameters
     * @return \Path\pathStructType\PathUpdateLockStatusResponse|bool
     */
    public function UpdateLockStatus(\Path\pathStructType\PathUpdateLockStatus $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UpdateLockStatus($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Path\pathStructType\PathUpdateLoanFeeDataResponse|\Path\pathStructType\PathUpdateLockStatusResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
