<?php

namespace Path\pathServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Acct pathServiceType
 * @package Path
 * @subpackage Services
 */
class PathAcct extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named AcctSetLoanData
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Path\pathStructType\PathAcctSetLoanData $parameters
     * @return \Path\pathStructType\PathAcctSetLoanDataResponse|bool
     */
    public function AcctSetLoanData(\Path\pathStructType\PathAcctSetLoanData $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AcctSetLoanData($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AcctRequestToken
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Path\pathStructType\PathAcctRequestToken $parameters
     * @return \Path\pathStructType\PathAcctRequestTokenResponse|bool
     */
    public function AcctRequestToken(\Path\pathStructType\PathAcctRequestToken $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AcctRequestToken($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AcctGetBUList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Path\pathStructType\PathAcctGetBUList $parameters
     * @return \Path\pathStructType\PathAcctGetBUListResponse|bool
     */
    public function AcctGetBUList(\Path\pathStructType\PathAcctGetBUList $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AcctGetBUList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AcctGetStatusList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Path\pathStructType\PathAcctGetStatusList $parameters
     * @return \Path\pathStructType\PathAcctGetStatusListResponse|bool
     */
    public function AcctGetStatusList(\Path\pathStructType\PathAcctGetStatusList $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AcctGetStatusList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AcctSearchLoan
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Path\pathStructType\PathAcctSearchLoan $parameters
     * @return \Path\pathStructType\PathAcctSearchLoanResponse|bool
     */
    public function AcctSearchLoan(\Path\pathStructType\PathAcctSearchLoan $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AcctSearchLoan($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AcctGetMultiLoanData
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Path\pathStructType\PathAcctGetMultiLoanData $parameters
     * @return \Path\pathStructType\PathAcctGetMultiLoanDataResponse|bool
     */
    public function AcctGetMultiLoanData(\Path\pathStructType\PathAcctGetMultiLoanData $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AcctGetMultiLoanData($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AcctGetFeeList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Path\pathStructType\PathAcctGetFeeList $parameters
     * @return \Path\pathStructType\PathAcctGetFeeListResponse|bool
     */
    public function AcctGetFeeList(\Path\pathStructType\PathAcctGetFeeList $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AcctGetFeeList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Path\pathStructType\PathAcctGetBUListResponse|\Path\pathStructType\PathAcctGetFeeListResponse|\Path\pathStructType\PathAcctGetMultiLoanDataResponse|\Path\pathStructType\PathAcctGetStatusListResponse|\Path\pathStructType\PathAcctRequestTokenResponse|\Path\pathStructType\PathAcctSearchLoanResponse|\Path\pathStructType\PathAcctSetLoanDataResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
