<?php

namespace Path\pathStructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ResultValues pathStructType
 * @package Path
 * @subpackage Structs
 */
class PathResultValues extends AbstractStructBase
{
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Status;
    /**
     * The Message
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Message;
    /**
     * The GroupValues
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Path\pathArrayType\PathArrayOfLoanKeyValuePair
     */
    public $GroupValues;
    /**
     * Constructor method for ResultValues
     * @uses PathResultValues::setStatus()
     * @uses PathResultValues::setMessage()
     * @uses PathResultValues::setGroupValues()
     * @param int $status
     * @param string $message
     * @param \Path\pathArrayType\PathArrayOfLoanKeyValuePair $groupValues
     */
    public function __construct($status = null, $message = null, \Path\pathArrayType\PathArrayOfLoanKeyValuePair $groupValues = null)
    {
        $this
            ->setStatus($status)
            ->setMessage($message)
            ->setGroupValues($groupValues);
    }
    /**
     * Get Status value
     * @return int
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param int $status
     * @return \Path\pathStructType\PathResultValues
     */
    public function setStatus($status = null)
    {
        // validation for constraint: int
        if (!is_null($status) && !(is_int($status) || ctype_digit($status))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get Message value
     * @return string|null
     */
    public function getMessage()
    {
        return $this->Message;
    }
    /**
     * Set Message value
     * @param string $message
     * @return \Path\pathStructType\PathResultValues
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($message, true), gettype($message)), __LINE__);
        }
        $this->Message = $message;
        return $this;
    }
    /**
     * Get GroupValues value
     * @return \Path\pathArrayType\PathArrayOfLoanKeyValuePair|null
     */
    public function getGroupValues()
    {
        return $this->GroupValues;
    }
    /**
     * Set GroupValues value
     * @param \Path\pathArrayType\PathArrayOfLoanKeyValuePair $groupValues
     * @return \Path\pathStructType\PathResultValues
     */
    public function setGroupValues(\Path\pathArrayType\PathArrayOfLoanKeyValuePair $groupValues = null)
    {
        $this->GroupValues = $groupValues;
        return $this;
    }
}
