<?php

namespace Path\pathStructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ResultStatusList pathStructType
 * @package Path
 * @subpackage Structs
 */
class PathResultStatusList extends AbstractStructBase
{
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Status;
    /**
     * The Message
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Message;
    /**
     * The StatusList
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Path\pathArrayType\PathArrayOfString
     */
    public $StatusList;
    /**
     * Constructor method for ResultStatusList
     * @uses PathResultStatusList::setStatus()
     * @uses PathResultStatusList::setMessage()
     * @uses PathResultStatusList::setStatusList()
     * @param int $status
     * @param string $message
     * @param \Path\pathArrayType\PathArrayOfString $statusList
     */
    public function __construct($status = null, $message = null, \Path\pathArrayType\PathArrayOfString $statusList = null)
    {
        $this
            ->setStatus($status)
            ->setMessage($message)
            ->setStatusList($statusList);
    }
    /**
     * Get Status value
     * @return int
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param int $status
     * @return \Path\pathStructType\PathResultStatusList
     */
    public function setStatus($status = null)
    {
        // validation for constraint: int
        if (!is_null($status) && !(is_int($status) || ctype_digit($status))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get Message value
     * @return string|null
     */
    public function getMessage()
    {
        return $this->Message;
    }
    /**
     * Set Message value
     * @param string $message
     * @return \Path\pathStructType\PathResultStatusList
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($message, true), gettype($message)), __LINE__);
        }
        $this->Message = $message;
        return $this;
    }
    /**
     * Get StatusList value
     * @return \Path\pathArrayType\PathArrayOfString|null
     */
    public function getStatusList()
    {
        return $this->StatusList;
    }
    /**
     * Set StatusList value
     * @param \Path\pathArrayType\PathArrayOfString $statusList
     * @return \Path\pathStructType\PathResultStatusList
     */
    public function setStatusList(\Path\pathArrayType\PathArrayOfString $statusList = null)
    {
        $this->StatusList = $statusList;
        return $this;
    }
}
