<?php

namespace Path\pathStructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ResultLoanList pathStructType
 * @package Path
 * @subpackage Structs
 */
class PathResultLoanList extends AbstractStructBase
{
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Status;
    /**
     * The Message
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Message;
    /**
     * The LoanNumbers
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Path\pathArrayType\PathArrayOfString
     */
    public $LoanNumbers;
    /**
     * Constructor method for ResultLoanList
     * @uses PathResultLoanList::setStatus()
     * @uses PathResultLoanList::setMessage()
     * @uses PathResultLoanList::setLoanNumbers()
     * @param int $status
     * @param string $message
     * @param \Path\pathArrayType\PathArrayOfString $loanNumbers
     */
    public function __construct($status = null, $message = null, \Path\pathArrayType\PathArrayOfString $loanNumbers = null)
    {
        $this
            ->setStatus($status)
            ->setMessage($message)
            ->setLoanNumbers($loanNumbers);
    }
    /**
     * Get Status value
     * @return int
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param int $status
     * @return \Path\pathStructType\PathResultLoanList
     */
    public function setStatus($status = null)
    {
        // validation for constraint: int
        if (!is_null($status) && !(is_int($status) || ctype_digit($status))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get Message value
     * @return string|null
     */
    public function getMessage()
    {
        return $this->Message;
    }
    /**
     * Set Message value
     * @param string $message
     * @return \Path\pathStructType\PathResultLoanList
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($message, true), gettype($message)), __LINE__);
        }
        $this->Message = $message;
        return $this;
    }
    /**
     * Get LoanNumbers value
     * @return \Path\pathArrayType\PathArrayOfString|null
     */
    public function getLoanNumbers()
    {
        return $this->LoanNumbers;
    }
    /**
     * Set LoanNumbers value
     * @param \Path\pathArrayType\PathArrayOfString $loanNumbers
     * @return \Path\pathStructType\PathResultLoanList
     */
    public function setLoanNumbers(\Path\pathArrayType\PathArrayOfString $loanNumbers = null)
    {
        $this->LoanNumbers = $loanNumbers;
        return $this;
    }
}
