<?php

namespace Path\pathStructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddDocument pathStructType
 * @package Path
 * @subpackage Structs
 */
class PathAddDocument extends AbstractStructBase
{
    /**
     * The vendorid
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $vendorid;
    /**
     * The apitoken
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $apitoken;
    /**
     * The vendorpw
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $vendorpw;
    /**
     * The documentname
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $documentname;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The documenttype
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $documenttype;
    /**
     * The documentfile
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $documentfile;
    /**
     * Constructor method for AddDocument
     * @uses PathAddDocument::setVendorid()
     * @uses PathAddDocument::setApitoken()
     * @uses PathAddDocument::setVendorpw()
     * @uses PathAddDocument::setDocumentname()
     * @uses PathAddDocument::setDescription()
     * @uses PathAddDocument::setDocumenttype()
     * @uses PathAddDocument::setDocumentfile()
     * @param string $vendorid
     * @param string $apitoken
     * @param string $vendorpw
     * @param string $documentname
     * @param string $description
     * @param string $documenttype
     * @param string $documentfile
     */
    public function __construct($vendorid = null, $apitoken = null, $vendorpw = null, $documentname = null, $description = null, $documenttype = null, $documentfile = null)
    {
        $this
            ->setVendorid($vendorid)
            ->setApitoken($apitoken)
            ->setVendorpw($vendorpw)
            ->setDocumentname($documentname)
            ->setDescription($description)
            ->setDocumenttype($documenttype)
            ->setDocumentfile($documentfile);
    }
    /**
     * Get vendorid value
     * @return string|null
     */
    public function getVendorid()
    {
        return $this->vendorid;
    }
    /**
     * Set vendorid value
     * @param string $vendorid
     * @return \Path\pathStructType\PathAddDocument
     */
    public function setVendorid($vendorid = null)
    {
        // validation for constraint: string
        if (!is_null($vendorid) && !is_string($vendorid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vendorid, true), gettype($vendorid)), __LINE__);
        }
        $this->vendorid = $vendorid;
        return $this;
    }
    /**
     * Get apitoken value
     * @return string|null
     */
    public function getApitoken()
    {
        return $this->apitoken;
    }
    /**
     * Set apitoken value
     * @param string $apitoken
     * @return \Path\pathStructType\PathAddDocument
     */
    public function setApitoken($apitoken = null)
    {
        // validation for constraint: string
        if (!is_null($apitoken) && !is_string($apitoken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($apitoken, true), gettype($apitoken)), __LINE__);
        }
        $this->apitoken = $apitoken;
        return $this;
    }
    /**
     * Get vendorpw value
     * @return string|null
     */
    public function getVendorpw()
    {
        return $this->vendorpw;
    }
    /**
     * Set vendorpw value
     * @param string $vendorpw
     * @return \Path\pathStructType\PathAddDocument
     */
    public function setVendorpw($vendorpw = null)
    {
        // validation for constraint: string
        if (!is_null($vendorpw) && !is_string($vendorpw)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vendorpw, true), gettype($vendorpw)), __LINE__);
        }
        $this->vendorpw = $vendorpw;
        return $this;
    }
    /**
     * Get documentname value
     * @return string|null
     */
    public function getDocumentname()
    {
        return $this->documentname;
    }
    /**
     * Set documentname value
     * @param string $documentname
     * @return \Path\pathStructType\PathAddDocument
     */
    public function setDocumentname($documentname = null)
    {
        // validation for constraint: string
        if (!is_null($documentname) && !is_string($documentname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentname, true), gettype($documentname)), __LINE__);
        }
        $this->documentname = $documentname;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \Path\pathStructType\PathAddDocument
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get documenttype value
     * @return string|null
     */
    public function getDocumenttype()
    {
        return $this->documenttype;
    }
    /**
     * Set documenttype value
     * @param string $documenttype
     * @return \Path\pathStructType\PathAddDocument
     */
    public function setDocumenttype($documenttype = null)
    {
        // validation for constraint: string
        if (!is_null($documenttype) && !is_string($documenttype)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documenttype, true), gettype($documenttype)), __LINE__);
        }
        $this->documenttype = $documenttype;
        return $this;
    }
    /**
     * Get documentfile value
     * @return string|null
     */
    public function getDocumentfile()
    {
        return $this->documentfile;
    }
    /**
     * Set documentfile value
     * @param string $documentfile
     * @return \Path\pathStructType\PathAddDocument
     */
    public function setDocumentfile($documentfile = null)
    {
        // validation for constraint: string
        if (!is_null($documentfile) && !is_string($documentfile)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentfile, true), gettype($documentfile)), __LINE__);
        }
        $this->documentfile = $documentfile;
        return $this;
    }
}
