<?php

namespace Path\pathStructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RequestLoanToken pathStructType
 * @package Path
 * @subpackage Structs
 */
class PathRequestLoanToken extends AbstractStructBase
{
    /**
     * The vendorid
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $vendorid;
    /**
     * The vendorpw
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $vendorpw;
    /**
     * The accountid
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $accountid;
    /**
     * The accountsecuritykey
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $accountsecuritykey;
    /**
     * The loannumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $loannumber;
    /**
     * Constructor method for RequestLoanToken
     * @uses PathRequestLoanToken::setVendorid()
     * @uses PathRequestLoanToken::setVendorpw()
     * @uses PathRequestLoanToken::setAccountid()
     * @uses PathRequestLoanToken::setAccountsecuritykey()
     * @uses PathRequestLoanToken::setLoannumber()
     * @param string $vendorid
     * @param string $vendorpw
     * @param string $accountid
     * @param string $accountsecuritykey
     * @param string $loannumber
     */
    public function __construct($vendorid = null, $vendorpw = null, $accountid = null, $accountsecuritykey = null, $loannumber = null)
    {
        $this
            ->setVendorid($vendorid)
            ->setVendorpw($vendorpw)
            ->setAccountid($accountid)
            ->setAccountsecuritykey($accountsecuritykey)
            ->setLoannumber($loannumber);
    }
    /**
     * Get vendorid value
     * @return string|null
     */
    public function getVendorid()
    {
        return $this->vendorid;
    }
    /**
     * Set vendorid value
     * @param string $vendorid
     * @return \Path\pathStructType\PathRequestLoanToken
     */
    public function setVendorid($vendorid = null)
    {
        // validation for constraint: string
        if (!is_null($vendorid) && !is_string($vendorid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vendorid, true), gettype($vendorid)), __LINE__);
        }
        $this->vendorid = $vendorid;
        return $this;
    }
    /**
     * Get vendorpw value
     * @return string|null
     */
    public function getVendorpw()
    {
        return $this->vendorpw;
    }
    /**
     * Set vendorpw value
     * @param string $vendorpw
     * @return \Path\pathStructType\PathRequestLoanToken
     */
    public function setVendorpw($vendorpw = null)
    {
        // validation for constraint: string
        if (!is_null($vendorpw) && !is_string($vendorpw)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vendorpw, true), gettype($vendorpw)), __LINE__);
        }
        $this->vendorpw = $vendorpw;
        return $this;
    }
    /**
     * Get accountid value
     * @return string|null
     */
    public function getAccountid()
    {
        return $this->accountid;
    }
    /**
     * Set accountid value
     * @param string $accountid
     * @return \Path\pathStructType\PathRequestLoanToken
     */
    public function setAccountid($accountid = null)
    {
        // validation for constraint: string
        if (!is_null($accountid) && !is_string($accountid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountid, true), gettype($accountid)), __LINE__);
        }
        $this->accountid = $accountid;
        return $this;
    }
    /**
     * Get accountsecuritykey value
     * @return string|null
     */
    public function getAccountsecuritykey()
    {
        return $this->accountsecuritykey;
    }
    /**
     * Set accountsecuritykey value
     * @param string $accountsecuritykey
     * @return \Path\pathStructType\PathRequestLoanToken
     */
    public function setAccountsecuritykey($accountsecuritykey = null)
    {
        // validation for constraint: string
        if (!is_null($accountsecuritykey) && !is_string($accountsecuritykey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountsecuritykey, true), gettype($accountsecuritykey)), __LINE__);
        }
        $this->accountsecuritykey = $accountsecuritykey;
        return $this;
    }
    /**
     * Get loannumber value
     * @return string|null
     */
    public function getLoannumber()
    {
        return $this->loannumber;
    }
    /**
     * Set loannumber value
     * @param string $loannumber
     * @return \Path\pathStructType\PathRequestLoanToken
     */
    public function setLoannumber($loannumber = null)
    {
        // validation for constraint: string
        if (!is_null($loannumber) && !is_string($loannumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($loannumber, true), gettype($loannumber)), __LINE__);
        }
        $this->loannumber = $loannumber;
        return $this;
    }
}
