<?php

namespace Path\pathStructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ResultLoanXML pathStructType
 * @package Path
 * @subpackage Structs
 */
class PathResultLoanXML extends AbstractStructBase
{
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Status;
    /**
     * The Message
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Message;
    /**
     * The LoanXML
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LoanXML;
    /**
     * Constructor method for ResultLoanXML
     * @uses PathResultLoanXML::setStatus()
     * @uses PathResultLoanXML::setMessage()
     * @uses PathResultLoanXML::setLoanXML()
     * @param int $status
     * @param string $message
     * @param string $loanXML
     */
    public function __construct($status = null, $message = null, $loanXML = null)
    {
        $this
            ->setStatus($status)
            ->setMessage($message)
            ->setLoanXML($loanXML);
    }
    /**
     * Get Status value
     * @return int
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param int $status
     * @return \Path\pathStructType\PathResultLoanXML
     */
    public function setStatus($status = null)
    {
        // validation for constraint: int
        if (!is_null($status) && !(is_int($status) || ctype_digit($status))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get Message value
     * @return string|null
     */
    public function getMessage()
    {
        return $this->Message;
    }
    /**
     * Set Message value
     * @param string $message
     * @return \Path\pathStructType\PathResultLoanXML
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($message, true), gettype($message)), __LINE__);
        }
        $this->Message = $message;
        return $this;
    }
    /**
     * Get LoanXML value
     * @return string|null
     */
    public function getLoanXML()
    {
        return $this->LoanXML;
    }
    /**
     * Set LoanXML value
     * @param string $loanXML
     * @return \Path\pathStructType\PathResultLoanXML
     */
    public function setLoanXML($loanXML = null)
    {
        // validation for constraint: string
        if (!is_null($loanXML) && !is_string($loanXML)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($loanXML, true), gettype($loanXML)), __LINE__);
        }
        $this->LoanXML = $loanXML;
        return $this;
    }
}
