<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the first needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientBase class (each generated ServiceType class extends this class)
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://www.calyxpath.com/Interface/API/PWS.asmx?WSDL',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc...
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://www.calyxpath.com/Interface/API/PWS.asmx?WSDL',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => \Path\PathClassMap::get(),
);
/**
 * Samples for Get ServiceType
 */
$get = new \Path\pathServiceType\PathGet($options);
/**
 * Sample call for GetLoanDataByToken operation/method
 */
if ($get->GetLoanDataByToken(new \Path\pathStructType\PathGetLoanDataByToken()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetLoanXMLByToken operation/method
 */
if ($get->GetLoanXMLByToken(new \Path\pathStructType\PathGetLoanXMLByToken()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetLoanFeeData operation/method
 */
if ($get->GetLoanFeeData(new \Path\pathStructType\PathGetLoanFeeData()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetDocumentList operation/method
 */
if ($get->GetDocumentList(new \Path\pathStructType\PathGetDocumentList()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetDocumentFile operation/method
 */
if ($get->GetDocumentFile(new \Path\pathStructType\PathGetDocumentFile()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Set ServiceType
 */
$set = new \Path\pathServiceType\PathSet($options);
/**
 * Sample call for SetLoanDataByToken operation/method
 */
if ($set->SetLoanDataByToken(new \Path\pathStructType\PathSetLoanDataByToken()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Samples for Acct ServiceType
 */
$acct = new \Path\pathServiceType\PathAcct($options);
/**
 * Sample call for AcctSetLoanData operation/method
 */
if ($acct->AcctSetLoanData(new \Path\pathStructType\PathAcctSetLoanData()) !== false) {
    print_r($acct->getResult());
} else {
    print_r($acct->getLastError());
}
/**
 * Sample call for AcctRequestToken operation/method
 */
if ($acct->AcctRequestToken(new \Path\pathStructType\PathAcctRequestToken()) !== false) {
    print_r($acct->getResult());
} else {
    print_r($acct->getLastError());
}
/**
 * Sample call for AcctGetBUList operation/method
 */
if ($acct->AcctGetBUList(new \Path\pathStructType\PathAcctGetBUList()) !== false) {
    print_r($acct->getResult());
} else {
    print_r($acct->getLastError());
}
/**
 * Sample call for AcctGetStatusList operation/method
 */
if ($acct->AcctGetStatusList(new \Path\pathStructType\PathAcctGetStatusList()) !== false) {
    print_r($acct->getResult());
} else {
    print_r($acct->getLastError());
}
/**
 * Sample call for AcctSearchLoan operation/method
 */
if ($acct->AcctSearchLoan(new \Path\pathStructType\PathAcctSearchLoan()) !== false) {
    print_r($acct->getResult());
} else {
    print_r($acct->getLastError());
}
/**
 * Sample call for AcctGetMultiLoanData operation/method
 */
if ($acct->AcctGetMultiLoanData(new \Path\pathStructType\PathAcctGetMultiLoanData()) !== false) {
    print_r($acct->getResult());
} else {
    print_r($acct->getLastError());
}
/**
 * Sample call for AcctGetFeeList operation/method
 */
if ($acct->AcctGetFeeList(new \Path\pathStructType\PathAcctGetFeeList()) !== false) {
    print_r($acct->getResult());
} else {
    print_r($acct->getLastError());
}
/**
 * Samples for Extend ServiceType
 */
$extend = new \Path\pathServiceType\PathExtend($options);
/**
 * Sample call for ExtendTheToken operation/method
 */
if ($extend->ExtendTheToken(new \Path\pathStructType\PathExtendTheToken()) !== false) {
    print_r($extend->getResult());
} else {
    print_r($extend->getLastError());
}
/**
 * Samples for Update ServiceType
 */
$update = new \Path\pathServiceType\PathUpdate($options);
/**
 * Sample call for UpdateLoanFeeData operation/method
 */
if ($update->UpdateLoanFeeData(new \Path\pathStructType\PathUpdateLoanFeeData()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateLockStatus operation/method
 */
if ($update->UpdateLockStatus(new \Path\pathStructType\PathUpdateLockStatus()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Samples for Add ServiceType
 */
$add = new \Path\pathServiceType\PathAdd($options);
/**
 * Sample call for AddNewLoanFeeData operation/method
 */
if ($add->AddNewLoanFeeData(new \Path\pathStructType\PathAddNewLoanFeeData()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddDocument operation/method
 */
if ($add->AddDocument(new \Path\pathStructType\PathAddDocument()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddDocumentFile operation/method
 */
if ($add->AddDocumentFile(new \Path\pathStructType\PathAddDocumentFile()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Samples for Delete ServiceType
 */
$delete = new \Path\pathServiceType\PathDelete($options);
/**
 * Sample call for DeleteLoanFeeData operation/method
 */
if ($delete->DeleteLoanFeeData(new \Path\pathStructType\PathDeleteLoanFeeData()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Samples for Request ServiceType
 */
$request = new \Path\pathServiceType\PathRequest($options);
/**
 * Sample call for RequestLoanToken operation/method
 */
if ($request->RequestLoanToken(new \Path\pathStructType\PathRequestLoanToken()) !== false) {
    print_r($request->getResult());
} else {
    print_r($request->getLastError());
}
