<?php

namespace Path\pathStructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BUInfo pathStructType
 * @package Path
 * @subpackage Structs
 */
class PathBUInfo extends AbstractStructBase
{
    /**
     * The buid
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $buid;
    /**
     * The buname
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $buname;
    /**
     * Constructor method for BUInfo
     * @uses PathBUInfo::setBuid()
     * @uses PathBUInfo::setBuname()
     * @param int $buid
     * @param string $buname
     */
    public function __construct($buid = null, $buname = null)
    {
        $this
            ->setBuid($buid)
            ->setBuname($buname);
    }
    /**
     * Get buid value
     * @return int
     */
    public function getBuid()
    {
        return $this->buid;
    }
    /**
     * Set buid value
     * @param int $buid
     * @return \Path\pathStructType\PathBUInfo
     */
    public function setBuid($buid = null)
    {
        // validation for constraint: int
        if (!is_null($buid) && !(is_int($buid) || ctype_digit($buid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($buid, true), gettype($buid)), __LINE__);
        }
        $this->buid = $buid;
        return $this;
    }
    /**
     * Get buname value
     * @return string|null
     */
    public function getBuname()
    {
        return $this->buname;
    }
    /**
     * Set buname value
     * @param string $buname
     * @return \Path\pathStructType\PathBUInfo
     */
    public function setBuname($buname = null)
    {
        // validation for constraint: string
        if (!is_null($buname) && !is_string($buname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($buname, true), gettype($buname)), __LINE__);
        }
        $this->buname = $buname;
        return $this;
    }
}
